/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.physics.MovementController;
import de.gurkenlabs.litiengine.util.MathUtilities;

public abstract class AccelerationMovementController<T extends IMobileEntity>
extends MovementController<T> {
    private float dx;
    private float dy;
    private boolean movedX;
    private boolean movedY;
    private double velocityX;
    private double velocityY;

    public AccelerationMovementController(T mobileEntity) {
        super(mobileEntity);
    }

    @Override
    public void update() {
        double dec;
        super.update();
        if (!this.isMovementAllowed()) {
            this.velocityX = 0.0;
            this.velocityY = 0.0;
            return;
        }
        long deltaTime = Game.getLoop().getDeltaTime();
        double maxPixelsPerTick = (double)this.getEntity().getVelocity() / 1000.0 * (double)Math.min(deltaTime, 50L);
        double accelerationRatio = (double)deltaTime / (double)this.getEntity().getAcceleration();
        double decelerationRatio = (double)deltaTime / (double)this.getEntity().getDeceleration();
        double inc = this.getEntity().getAcceleration() == 0 ? maxPixelsPerTick : accelerationRatio * maxPixelsPerTick;
        double d = dec = this.getEntity().getDeceleration() == 0 ? maxPixelsPerTick : decelerationRatio * maxPixelsPerTick;
        if (this.isMovedX() && this.isMovedY()) {
            inc /= Math.sqrt(2.0);
        }
        if (this.isMovedX()) {
            this.setVelocityX(this.getVelocityX() + (this.getDx() > 0.0f ? inc : -inc));
            this.setVelocityX(MathUtilities.clamp(this.getVelocityX(), -maxPixelsPerTick, maxPixelsPerTick));
            this.setDx(0.0f);
            this.setMovedX(false);
        } else {
            this.decellerateVelocityX(dec);
        }
        if (this.isMovedY()) {
            this.setVelocityY(this.getVelocityY() + (this.getDy() > 0.0f ? inc : -inc));
            this.setVelocityY(MathUtilities.clamp(this.getVelocityY(), -maxPixelsPerTick, maxPixelsPerTick));
            this.setDy(0.0f);
            this.setMovedY(false);
        } else {
            this.decellerateVelocityY(dec);
        }
        if (this.getVelocityX() == 0.0 && this.getVelocityY() == 0.0) {
            return;
        }
        this.moveEntity(this.getVelocityX(), this.getVelocityY());
    }

    public float getDx() {
        return this.dx;
    }

    public void setDx(float dx) {
        this.dx = dx;
    }

    public float getDy() {
        return this.dy;
    }

    public void setDy(float dy) {
        this.dy = dy;
    }

    public boolean isMovedX() {
        return this.movedX;
    }

    public void setMovedX(boolean movedX) {
        this.movedX = movedX;
    }

    public boolean isMovedY() {
        return this.movedY;
    }

    public void setMovedY(boolean movedY) {
        this.movedY = movedY;
    }

    public double getVelocityX() {
        return this.velocityX;
    }

    public void setVelocityX(double velocityX) {
        this.velocityX = velocityX;
    }

    public void decellerateVelocityX(double dec) {
        if (this.getVelocityX() > 0.0) {
            if (dec > this.getVelocityX()) {
                this.setVelocityX(0.0);
            } else {
                this.setVelocityX(this.getVelocityX() - dec);
            }
        } else if (this.getVelocityX() < 0.0) {
            if (dec < this.getVelocityX()) {
                this.setVelocityX(0.0);
            } else {
                this.setVelocityX(this.getVelocityX() + dec);
            }
        }
        if (Math.abs(this.getVelocityX()) < this.getStopThreshold()) {
            this.setVelocityX(0.0);
        }
    }

    public void decellerateVelocityY(double dec) {
        if (this.getVelocityY() > 0.0) {
            if (dec > this.getVelocityY()) {
                this.setVelocityY(0.0);
            } else {
                this.setVelocityY(this.getVelocityY() - dec);
            }
        } else if (this.getVelocityY() < 0.0) {
            if (dec < this.getVelocityY()) {
                this.setVelocityY(0.0);
            } else {
                this.setVelocityY(this.getVelocityY() + dec);
            }
        }
        if (Math.abs(this.getVelocityY()) < this.getStopThreshold()) {
            this.setVelocityY(0.0);
        }
    }

    public double getVelocityY() {
        return this.velocityY;
    }

    public void setVelocityY(double velocityY) {
        this.velocityY = velocityY;
    }

    protected double getStopThreshold() {
        return 0.0025 * (double)Game.getLoop().getDeltaTime();
    }
}

