/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net.server;

import de.gurkenlabs.litiengine.net.server.ClientConnection;
import de.gurkenlabs.litiengine.net.server.IClientConnectionManager;
import java.net.InetAddress;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class ClientConnectionManager
extends CopyOnWriteArrayList<ClientConnection>
implements IClientConnectionManager {
    private static final long serialVersionUID = 3719486731770172645L;

    @Override
    public ClientConnection get(int clientId) {
        if (this.stream().noneMatch(connection -> connection.getId() == clientId)) {
            return null;
        }
        Optional<ClientConnection> opt = this.stream().filter(connection -> connection.getId() == clientId).findFirst();
        return opt.isPresent() ? opt.get() : null;
    }

    @Override
    public boolean isConnected(int clientId, InetAddress address, int port) {
        return this.stream().anyMatch(connection -> connection.equals(clientId, address, port));
    }

    @Override
    public void setSignOfLife(int clientId) {
        for (ClientConnection connection : this) {
            if (connection.getId() != clientId) continue;
            connection.setSignOfLife(new Date());
        }
    }
}

