/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;

public class ClientConnection
implements Serializable {
    private static int idSequence = 0;
    private static final long serialVersionUID = 6311152055968351408L;
    private final int id;
    private final InetAddress ipAddress;
    private Date lastSignOfLife;
    private final int port;
    private final String userName;

    public ClientConnection(ClientConnection connection) {
        this.ipAddress = connection.getIpAddress();
        this.port = connection.getPort();
        this.userName = connection.getUserName();
        this.lastSignOfLife = connection.getLastSignOfLife();
        this.id = connection.getId();
    }

    public ClientConnection(InetAddress ipAddress, int port, String userName) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.userName = userName;
        this.lastSignOfLife = new Date();
        this.id = ++idSequence;
    }

    public boolean equals(long id, InetAddress address, int port) {
        return (long)this.getId() == id && this.getIpAddress().equals(address) && this.getPort() == port;
    }

    public int getId() {
        return this.id;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public Date getLastSignOfLife() {
        return this.lastSignOfLife;
    }

    public long getLastSignOfLifeInMs() {
        return new Date().getTime() - this.getLastSignOfLife().getTime();
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setSignOfLife(Date lastSignOfLife) {
        this.lastSignOfLife = lastSignOfLife;
    }

    public String toString() {
        return "Client(" + this.getId() + "): " + this.getIpAddress().getHostAddress() + ":" + this.getPort() + "; last sign of life: " + this.getLastSignOfLifeInMs() + "ms ago";
    }
}

