/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net.messages.handlers;

import de.gurkenlabs.litiengine.net.messages.IMessageHandler;
import de.gurkenlabs.litiengine.net.messages.MessagePackage;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MessageHandler<T extends Serializable>
implements IMessageHandler {
    private static final Logger log = Logger.getLogger(MessageHandler.class.getName());

    @Override
    public void handle(byte[] data, InetAddress address, int port) {
        Serializable message = (Serializable)new MessagePackage(data).getObject();
        if (message == null) {
            return;
        }
        if (!this.validate(message)) {
            log.log(Level.INFO, "Data from {0}:{1} is not valid for the messagehandler {2}.", new Object[]{address.getHostAddress(), port, this.getClass().getSimpleName()});
            return;
        }
        this.handle(message, address, port);
    }

    protected abstract void handle(T var1, InetAddress var2, int var3);

    protected boolean validate(T message) {
        return message != null;
    }
}

