/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net;

import de.gurkenlabs.litiengine.net.IIncomingPacketObserver;
import de.gurkenlabs.litiengine.net.IPacketReceiver;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UdpPacketReceiver
extends Thread
implements IPacketReceiver {
    private static final Logger log = Logger.getLogger(UdpPacketReceiver.class.getName());
    ArrayList<IIncomingPacketObserver> incomingPacketObservers = new ArrayList();
    private boolean isTerminated;
    private DatagramSocket socket;

    public UdpPacketReceiver(DatagramSocket socket) {
        this.socket = socket;
    }

    public UdpPacketReceiver(int port) {
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (SocketException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void registerForIncomingPackets(IIncomingPacketObserver observer) {
        this.incomingPacketObservers.add(observer);
    }

    @Override
    public void run() {
        while (!this.isTerminated) {
            byte[] data = new byte[10000];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            try {
                this.socket.receive(packet);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            for (IIncomingPacketObserver packetObserver : this.incomingPacketObservers) {
                packetObserver.packetReceived(packet.getData(), packet.getAddress(), packet.getPort());
            }
        }
        this.socket.close();
    }

    @Override
    public void terminate() {
        this.isTerminated = true;
    }
}

