/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.input.IGamepad;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.physics.AccelerationMovementController;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;
import net.java.games.input.Component;

public class GamepadEntityController<T extends IMobileEntity>
extends AccelerationMovementController<T> {
    private int gamePadIndex = -1;
    private double gamePadDeadzone = 0.15;
    private double gamePadRightStick = 0.08;
    private boolean rotateWithRightStick = false;

    public GamepadEntityController(T entity, boolean rotateWithRightStick) {
        super(entity);
        if (Input.getGamepad() != null) {
            this.gamePadIndex = Input.getGamepad().getIndex();
        }
        this.rotateWithRightStick = rotateWithRightStick;
        Input.gamepadManager().onGamepadAdded(pad -> {
            if (this.gamePadIndex == -1) {
                this.gamePadIndex = pad.getIndex();
            }
        });
        Input.gamepadManager().onGamepadRemoved(pad -> {
            if (this.gamePadIndex == pad.getIndex()) {
                this.gamePadIndex = -1;
                IGamepad newGamePad = Input.getGamepad();
                if (newGamePad != null) {
                    this.gamePadIndex = newGamePad.getIndex();
                }
            }
        });
    }

    @Override
    public void update() {
        this.retrieveGamepadValues();
        super.update();
    }

    public double getGamePadDeadzone() {
        return this.gamePadDeadzone;
    }

    public double getGamePadRightStick() {
        return this.gamePadRightStick;
    }

    public boolean isRotateWithRightStick() {
        return this.rotateWithRightStick;
    }

    public void setGamePadRightStick(double gamePadRightStick) {
        this.gamePadRightStick = gamePadRightStick;
    }

    public void setGamePadDeadzone(double gamePadDeadzone) {
        this.gamePadDeadzone = gamePadDeadzone;
    }

    public void setRotateWithRightStick(boolean rotateWithRightStick) {
        this.rotateWithRightStick = rotateWithRightStick;
    }

    private void retrieveGamepadValues() {
        if (this.gamePadIndex == -1 || this.gamePadIndex != -1 && Input.getGamepad(this.gamePadIndex) == null) {
            return;
        }
        float x = Input.getGamepad(this.gamePadIndex).getPollData(Component.Identifier.Axis.X);
        float y = Input.getGamepad(this.gamePadIndex).getPollData(Component.Identifier.Axis.Y);
        if ((double)Math.abs(x) > this.gamePadDeadzone) {
            this.setDx(x);
            this.setMovedX(true);
        }
        if ((double)Math.abs(y) > this.gamePadDeadzone) {
            this.setDy(y);
            this.setMovedY(true);
        }
        if (this.isRotateWithRightStick()) {
            float rightX = Input.getGamepad(this.gamePadIndex).getPollData(Component.Identifier.Axis.RX);
            float rightY = Input.getGamepad(this.gamePadIndex).getPollData(Component.Identifier.Axis.RY);
            float targetX = 0.0f;
            float targetY = 0.0f;
            if ((double)Math.abs(rightX) > this.gamePadRightStick) {
                targetX = rightX;
            }
            if ((double)Math.abs(rightY) > this.gamePadRightStick) {
                targetY = rightY;
            }
            if (targetX != 0.0f || targetY != 0.0f) {
                Point2D.Double target = new Point2D.Double(this.getEntity().getDimensionCenter().getX() + (double)targetX, this.getEntity().getDimensionCenter().getY() + (double)targetY);
                double angle = GeometricUtilities.calcRotationAngleInDegrees(this.getEntity().getDimensionCenter(), target);
                this.getEntity().setAngle((float)angle);
            }
        }
    }
}

