/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui.screens;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.RenderComponent;
import de.gurkenlabs.litiengine.gui.screens.IScreen;
import de.gurkenlabs.litiengine.gui.screens.IScreenManager;
import de.gurkenlabs.litiengine.gui.screens.Resolution;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.JFrame;

public class ScreenManager
extends JFrame
implements IScreenManager,
WindowStateListener,
WindowFocusListener {
    private static final int SCREENCHANGETIMEOUT = 200;
    private static final int ICONIFIED_MAX_FPS = 1;
    private static final int NONE_FOCUS_MAX_FPS = 10;
    private static final long serialVersionUID = 7958549828482285935L;
    private final transient List<Consumer<Dimension>> resolutionChangedConsumer = new CopyOnWriteArrayList<Consumer<Dimension>>();
    private final transient List<Consumer<IScreen>> screenChangedConsumer = new CopyOnWriteArrayList<Consumer<IScreen>>();
    private final transient List<IScreen> screens = new CopyOnWriteArrayList<IScreen>();
    private transient IScreen currentScreen;
    private long lastScreenChange = 0L;
    private final RenderComponent renderCanvas;
    private float resolutionScale = 1.0f;
    private Dimension resolution;
    private Point screenLocation;

    public ScreenManager(String gameTitle) {
        super(gameTitle);
        this.setResizable(false);
        this.setBackground(Color.BLACK);
        this.setDefaultCloseOperation(3);
        this.setDefaultCloseOperation(0);
        RenderComponent comp = new RenderComponent(Game.getConfiguration().graphics().getResolution());
        this.add(comp);
        this.renderCanvas = comp;
        this.getRenderComponent().addComponentListener(new ResizedEventListener());
        this.addWindowStateListener(this);
        this.addWindowFocusListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Game.terminate();
            }
        });
    }

    @Override
    public void addScreen(IScreen screen) {
        this.screens.add(screen);
        screen.setWidth(this.getWidth());
        screen.setHeight(this.getHeight());
        if (this.getCurrentScreen() == null) {
            this.displayScreen(screen);
        }
    }

    @Override
    public void displayScreen(IScreen screen) {
        this.displayScreen(screen.getName());
    }

    @Override
    public void displayScreen(String screen) {
        if (this.getCurrentScreen() != null && this.getCurrentScreen().getName().equalsIgnoreCase(screen) || this.screens.stream().noneMatch(element -> element.getName().equalsIgnoreCase(screen))) {
            return;
        }
        if (Game.hasStarted() && System.currentTimeMillis() - this.lastScreenChange < 200L) {
            return;
        }
        Optional<IScreen> opt = this.screens.stream().filter(element -> element.getName().equalsIgnoreCase(screen)).findFirst();
        if (!opt.isPresent()) {
            return;
        }
        IScreen targetScreen = opt.get();
        if (this.getCurrentScreen() != null) {
            this.getCurrentScreen().suspend();
            Game.getRenderLoop().unregister(this.getCurrentScreen());
        }
        this.currentScreen = targetScreen;
        this.getCurrentScreen().prepare();
        this.setVisible(true);
        Game.getRenderLoop().register(this.getCurrentScreen());
        this.lastScreenChange = System.currentTimeMillis();
        for (Consumer<IScreen> consumer : this.screenChangedConsumer) {
            consumer.accept(this.getCurrentScreen());
        }
    }

    @Override
    public IScreen getCurrentScreen() {
        return this.currentScreen;
    }

    @Override
    public RenderComponent getRenderComponent() {
        return this.renderCanvas;
    }

    @Override
    public Dimension getResolution() {
        return this.resolution;
    }

    @Override
    public Point getScreenLocation() {
        if (this.screenLocation != null) {
            return this.screenLocation;
        }
        this.screenLocation = this.getLocationOnScreen();
        return this.screenLocation;
    }

    @Override
    public void init(int width, int height, boolean fullscreen) {
        if (fullscreen) {
            this.setUndecorated(true);
            this.setExtendedState(6);
            this.setVisible(true);
            this.setResolution(Resolution.custom(this.getSize().width, this.getSize().height, "fullscreen"));
        } else {
            this.setResolution(Game.getConfiguration().graphics().getResolution());
            this.setVisible(true);
        }
        this.getRenderComponent().init();
        this.resolution = this.getRenderComponent().getSize();
        this.requestFocus();
    }

    @Override
    public boolean isFocusOwner() {
        if (this.getRenderComponent() instanceof Component && this.getRenderComponent().isFocusOwner()) {
            return true;
        }
        return super.isFocusOwner();
    }

    @Override
    public void onResolutionChanged(Consumer<Dimension> resolutionConsumer) {
        if (this.resolutionChangedConsumer.contains(resolutionConsumer)) {
            return;
        }
        this.resolutionChangedConsumer.add(resolutionConsumer);
    }

    @Override
    public void onScreenChanged(Consumer<IScreen> screenConsumer) {
        if (!this.screenChangedConsumer.contains(screenConsumer)) {
            this.screenChangedConsumer.add(screenConsumer);
        }
    }

    @Override
    public void setResolution(Resolution res) {
        this.setResolution(res.getDimension());
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        if (e.getNewState() == 1) {
            Game.getRenderLoop().setMaxFps(1);
        } else {
            Game.getRenderLoop().setMaxFps(Game.getConfiguration().client().getMaxFps());
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        Game.getRenderLoop().setMaxFps(Game.getConfiguration().client().getMaxFps());
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (Game.getConfiguration().graphics().reduceFramesWhenNotFocused()) {
            Game.getRenderLoop().setMaxFps(10);
        }
    }

    private void setResolution(Dimension dim) {
        Dimension insetAwareDimension = new Dimension(dim.width + this.getInsets().left + this.getInsets().right, dim.height + this.getInsets().top + this.getInsets().bottom);
        if (Game.getConfiguration().graphics().enableResolutionScale()) {
            this.resolutionScale = (float)(dim.getWidth() / (double)Resolution.Ratio16x9.RES_1920x1080.getWidth());
            Game.getInfo().setDefaultRenderScale(Game.getInfo().getDefaultRenderScale() * this.resolutionScale);
        }
        this.setSize(insetAwareDimension);
    }

    @Override
    public float getResolutionScale() {
        return this.resolutionScale;
    }

    private class ResizedEventListener
    extends ComponentAdapter {
        private ResizedEventListener() {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            ScreenManager.this.resolution = ScreenManager.this.getRenderComponent().getSize();
            ScreenManager.this.resolutionChangedConsumer.forEach(consumer -> consumer.accept(ScreenManager.this.getSize()));
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            ScreenManager.this.screenLocation = null;
        }
    }
}

