/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextFieldComponent
extends ImageComponent {
    public static final String DOUBLE_FORMAT = "[-+]?[0-9]*\\.?[0-9]*([eE][-+]?[0-9]*)?";
    public static final String INTEGER_FORMAT = "[0-9]{1,10}";
    private static final Logger log = Logger.getLogger(TextFieldComponent.class.getName());
    private final List<Consumer<String>> changeConfirmedConsumers = new CopyOnWriteArrayList<Consumer<String>>();
    private boolean cursorVisible;
    private final int flickerDelay;
    private String format;
    private String fullText;
    private long lastToggled;
    private int maxLength = 0;

    public TextFieldComponent(double x, double y, double width, double height, Spritesheet spritesheet, String text) {
        super(x, y, width, height, spritesheet, text, null);
        this.setText(text);
        this.flickerDelay = 100;
        Input.keyboard().onKeyTyped(this::handleTypedKey);
        this.onClicked(e -> {
            if (!this.isSelected()) {
                this.toggleSelection();
            }
        });
        Input.mouse().onClicked((MouseEvent e) -> {
            if (!this.getBoundingBox().contains(Input.mouse().getLocation())) {
                this.setSelected(false);
            }
        });
        this.setTextAlignment(Align.LEFT);
    }

    public String getFormat() {
        return this.format;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public String getText() {
        return this.fullText;
    }

    public void handleTypedKey(KeyEvent event) {
        if (this.isSuspended() || !this.isSelected() || !this.isVisible() || !this.isEnabled()) {
            return;
        }
        switch (event.getKeyCode()) {
            case 8: {
                this.handleBackSpace();
                break;
            }
            case 32: {
                if (this.getText() == "") break;
                this.setText(this.getText() + " ");
                break;
            }
            case 10: {
                this.toggleSelection();
                this.changeConfirmedConsumers.forEach(c -> c.accept(this.getText()));
                log.log(Level.INFO, "{0} typed into TextField with ComponentID {1}", new Object[]{this.getText(), this.getComponentId()});
                break;
            }
            default: {
                this.handleNormalTyping(event);
            }
        }
    }

    public void onChangeConfirmed(Consumer<String> cons) {
        this.changeConfirmedConsumers.add(cons);
    }

    @Override
    public void render(Graphics2D g) {
        super.render(g);
        g.setFont(this.getAppearance().getFont());
        FontMetrics fm = g.getFontMetrics();
        if (this.isSelected() && Game.getLoop().getDeltaTime(this.lastToggled) > (long)this.flickerDelay) {
            this.cursorVisible = !this.cursorVisible;
            this.lastToggled = Game.getLoop().getTicks();
        }
        if (this.isSelected() && this.cursorVisible) {
            Rectangle2D.Double cursor = new Rectangle2D.Double(this.getX() + this.getTextX() + (double)fm.stringWidth(this.getTextToRender(g)), this.getY() + this.getTextY(), this.getAppearance().getFont().getSize2D() * 3.0f / 5.0f, this.getAppearance().getFont().getSize2D() * 1.0f / 5.0f);
            g.setColor(this.getAppearance().getForeColor());
            g.fill(cursor);
        }
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void setText(String text) {
        this.fullText = text;
    }

    private void handleBackSpace() {
        if (Input.keyboard().isPressed(16)) {
            while (this.getText().length() >= 1 && this.getText().charAt(this.getText().length() - 1) == ' ') {
                this.setText(this.getText().substring(0, this.getText().length() - 1));
            }
            while (this.getText().length() >= 1 && this.getText().charAt(this.getText().length() - 1) != ' ') {
                this.setText(this.getText().substring(0, this.getText().length() - 1));
            }
        } else if (this.getText().length() >= 1) {
            this.setText(this.getText().substring(0, this.getText().length() - 1));
        }
        if (!(this.getFormat() == null || this.getFormat() != INTEGER_FORMAT && this.getFormat() != DOUBLE_FORMAT || this.getText() != null && !this.getText().isEmpty())) {
            this.setText("0");
        }
    }

    private void handleNormalTyping(KeyEvent event) {
        Pattern pat;
        Matcher mat;
        if (this.getMaxLength() > 0 && this.getText().length() >= this.getMaxLength()) {
            return;
        }
        String text = Input.keyboard().getText(event);
        if (text == null || text.isEmpty()) {
            return;
        }
        if (this.getFormat() != null && !this.getFormat().isEmpty() && !(mat = (pat = Pattern.compile(this.getFormat())).matcher(this.getText() + text)).matches()) {
            return;
        }
        if (this.getFormat() != null && (this.getFormat() == INTEGER_FORMAT || this.getFormat() == DOUBLE_FORMAT) && this.getText().equals("0")) {
            this.setText("");
        }
        this.setText(this.getText() + text);
    }
}

