/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.GuiComponent;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class Slider
extends GuiComponent {
    private ImageComponent button1;
    private ImageComponent button2;
    private ImageComponent sliderBar;
    private final Spritesheet buttonSprite;
    private final Spritesheet sliderSprite;
    private final List<Consumer<Float>> changeConsumer = new CopyOnWriteArrayList<Consumer<Float>>();
    private float currentValue;
    private boolean isDragging;
    private final float minValue;
    private final float maxValue;
    private final boolean showArrowButtons;
    private float stepSize;

    public Slider(double x, double y, double width, double height, float minValue, float maxValue, float stepSize, Spritesheet buttonSprite, Spritesheet sliderSprite, boolean showArrowButtons) {
        super(x, y, width, height);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = stepSize;
        this.buttonSprite = buttonSprite;
        this.sliderSprite = sliderSprite;
        this.showArrowButtons = showArrowButtons;
    }

    public boolean arrowButtonsShown() {
        return this.showArrowButtons;
    }

    public ImageComponent getButton1() {
        return this.button1;
    }

    public ImageComponent getButton2() {
        return this.button2;
    }

    public Spritesheet getButtonSprite() {
        return this.buttonSprite;
    }

    public List<Consumer<Float>> getChangeConsumer() {
        return this.changeConsumer;
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public abstract Point2D getRelativeSliderPosition();

    public ImageComponent getSliderComponent() {
        return this.sliderBar;
    }

    public Spritesheet getSliderSprite() {
        return this.sliderSprite;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void onChange(Consumer<Float> c) {
        this.getChangeConsumer().add(c);
    }

    @Override
    public void prepare() {
        super.prepare();
        this.setCurrentValue((this.getMinValue() + this.getMaxValue()) / 2.0f);
        this.onChange(e -> this.sliderBar.setPosition(this.getRelativeSliderPosition()));
    }

    public void setCurrentValue(float newValue) {
        if (newValue >= this.getMinValue() && newValue <= this.getMaxValue()) {
            this.currentValue = newValue;
        } else if (newValue < this.getMinValue()) {
            this.currentValue = this.getMinValue();
        } else if (newValue > this.getMaxValue()) {
            this.currentValue = this.getMaxValue();
        }
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    public abstract void setValueRelativeToMousePosition();

    @Override
    protected void initializeComponents() {
    }

    protected void setButton1(ImageComponent button1) {
        this.button1 = button1;
        this.button1.onClicked(e -> {
            this.setCurrentValue(this.getCurrentValue() - this.getStepSize());
            this.getChangeConsumer().forEach(consumer -> consumer.accept(Float.valueOf(this.getCurrentValue())));
        });
        this.getComponents().add(button1);
    }

    protected void setButton2(ImageComponent button2) {
        this.button2 = button2;
        this.button2.onClicked(e -> {
            this.setCurrentValue(this.getCurrentValue() + this.getStepSize());
            this.getChangeConsumer().forEach(consumer -> consumer.accept(Float.valueOf(this.getCurrentValue())));
        });
        this.getComponents().add(button2);
    }

    protected void setSlider(ImageComponent slider) {
        this.sliderBar = slider;
        this.sliderBar.onMousePressed(e -> {
            this.isDragging = true;
        });
        Input.mouse().onDragged(e -> {
            if (this.isDragging()) {
                this.setValueRelativeToMousePosition();
                this.getChangeConsumer().forEach(consumer -> consumer.accept(Float.valueOf(this.getCurrentValue())));
            }
        });
        Input.mouse().onReleased(e -> {
            if (this.isDragging()) {
                this.isDragging = false;
            }
        });
        this.getComponents().add(slider);
    }
}

