/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.FontIcon;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.TextFieldComponent;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NumberAdjuster
extends TextFieldComponent {
    public static final FontIcon ARROW_DOWN = new FontIcon(ICON_FONT, "\ue84a");
    public static final FontIcon ARROW_UP = new FontIcon(ICON_FONT, "\ue84b");
    private static final Logger log = Logger.getLogger(NumberAdjuster.class.getName());
    private BigDecimal step;
    private BigDecimal lowerBound;
    private BigDecimal upperBound;
    private BigDecimal currentValue;
    private Spritesheet buttonSprite;
    private final List<Consumer<BigDecimal>> valueChangeConsumers;

    public NumberAdjuster(double x, double y, double width, double height, Spritesheet textBackground, Spritesheet buttonBackground, double lowerBound, double upperBound, double startValue, double stepSize) {
        super(x, y, width, height, textBackground, Double.toString(startValue));
        this.buttonSprite = buttonBackground;
        this.valueChangeConsumers = new CopyOnWriteArrayList<Consumer<BigDecimal>>();
        this.lowerBound = BigDecimal.valueOf(lowerBound);
        this.upperBound = BigDecimal.valueOf(upperBound);
        this.setCurrentValue(BigDecimal.valueOf(startValue));
        this.step = BigDecimal.valueOf(stepSize);
        this.setFormat("[-+]?[0-9]*\\.?[0-9]*([eE][-+]?[0-9]*)?");
    }

    public void decrement() {
        this.setCurrentValue(this.getCurrentValue().subtract(this.getStepSize()));
    }

    public Spritesheet getButtonSprite() {
        return this.buttonSprite;
    }

    public BigDecimal getCurrentValue() {
        return this.currentValue;
    }

    public BigDecimal getLowerBound() {
        return this.lowerBound;
    }

    public BigDecimal getStepSize() {
        return this.step;
    }

    public BigDecimal getUpperBound() {
        return this.upperBound;
    }

    public void increment() {
        this.setCurrentValue(this.getCurrentValue().add(this.getStepSize()));
    }

    public void onValueChange(Consumer<BigDecimal> cons) {
        this.valueChangeConsumers.add(cons);
    }

    @Override
    public void prepare() {
        ImageComponent buttonUp = new ImageComponent(this.getX() + this.getWidth(), this.getY(), this.getHeight() / 2.0, this.getHeight() / 2.0, this.getButtonSprite(), ARROW_UP.getText(), null);
        ImageComponent buttonDown = new ImageComponent(this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0, this.getHeight() / 2.0, this.getHeight() / 2.0, this.getButtonSprite(), ARROW_DOWN.getText(), null);
        buttonUp.getAppearance().setFont(ARROW_UP.getFont());
        buttonUp.getAppearanceDisabled().setFont(ARROW_UP.getFont());
        buttonUp.getAppearanceHovered().setFont(ARROW_UP.getFont());
        buttonDown.getAppearance().setFont(ARROW_UP.getFont());
        buttonDown.getAppearanceDisabled().setFont(ARROW_UP.getFont());
        buttonDown.getAppearanceHovered().setFont(ARROW_UP.getFont());
        this.getComponents().add(buttonUp);
        this.getComponents().add(buttonDown);
        super.prepare();
        buttonUp.onClicked(c -> this.increment());
        buttonDown.onClicked(c -> this.decrement());
        this.onChangeConfirmed(e -> {
            try {
                this.setCurrentValue(BigDecimal.valueOf(Double.parseDouble(this.getText())));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        });
    }

    public void setButtonSprite(Spritesheet buttonSprite) {
        this.buttonSprite = buttonSprite;
    }

    public void setCurrentValue(BigDecimal newValue) {
        this.currentValue = newValue.compareTo(this.getUpperBound()) > 0 ? this.getUpperBound() : (newValue.compareTo(this.getLowerBound()) < 0 ? this.getLowerBound() : newValue);
        this.setText(this.getCurrentValue() + "");
        this.valueChangeConsumers.forEach(c -> c.accept(this.getCurrentValue()));
    }

    public void setLowerBound(BigDecimal lowerBound) {
        this.lowerBound = lowerBound;
        if (this.getCurrentValue().compareTo(this.getLowerBound()) < 0) {
            this.setCurrentValue(this.getLowerBound());
        }
    }

    public void setStepSize(BigDecimal stepSize) {
        this.step = stepSize;
    }

    public void setUpperBound(BigDecimal upperBound) {
        this.upperBound = upperBound;
        if (this.getCurrentValue().compareTo(this.getUpperBound()) > 0) {
            this.setCurrentValue(this.getUpperBound());
        }
    }
}

