/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.FontIcon;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.Slider;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class HorizontalSlider
extends Slider {
    public static final FontIcon ARROW_LEFT = new FontIcon(ICON_FONT, "\ue805");
    public static final FontIcon ARROW_RIGHT = new FontIcon(ICON_FONT, "\ue806");
    private final double minSliderX = this.getX() + this.getHeight();
    private final double maxSliderX = this.getX() + this.getWidth() - this.getHeight() * 3.0;

    public HorizontalSlider(double x, double y, double width, double height, float minValue, float maxValue, float stepSize, Spritesheet buttonSprite, Spritesheet sliderSprite, boolean showArrowButtons) {
        super(x, y, width, height, minValue, maxValue, stepSize, buttonSprite, sliderSprite, showArrowButtons);
    }

    @Override
    public Point2D getRelativeSliderPosition() {
        return new Point2D.Double(this.minSliderX + (double)(this.getCurrentValue() / (this.getMaxValue() - this.getMinValue())) * (this.maxSliderX - this.minSliderX), this.getY());
    }

    @Override
    public void prepare() {
        if (this.arrowButtonsShown()) {
            this.setButton1(new ImageComponent(this.getX(), this.getY(), this.getHeight(), this.getHeight(), this.getButtonSprite(), ARROW_LEFT.getText(), null));
            this.getButton1().getAppearance().setFont(ARROW_LEFT.getFont());
            this.getButton1().getAppearanceDisabled().setFont(ARROW_LEFT.getFont());
            this.getButton1().getAppearanceHovered().setFont(ARROW_LEFT.getFont());
            this.setButton2(new ImageComponent(this.getX() + this.getWidth() - this.getHeight(), this.getY(), this.getHeight(), this.getHeight(), this.getButtonSprite(), ARROW_RIGHT.getText(), null));
            this.getButton2().getAppearance().setFont(ARROW_RIGHT.getFont());
            this.getButton2().getAppearanceDisabled().setFont(ARROW_RIGHT.getFont());
            this.getButton2().getAppearanceHovered().setFont(ARROW_RIGHT.getFont());
            this.getComponents().add(this.getButton1());
            this.getComponents().add(this.getButton2());
        }
        this.setSlider(new ImageComponent(this.getRelativeSliderPosition().getX(), this.getRelativeSliderPosition().getY(), this.getHeight() * 2.0, this.getHeight(), this.getSliderSprite(), "", null));
        this.getComponents().add(this.getSliderComponent());
        super.prepare();
    }

    @Override
    public void render(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke((float)(this.getHeight() / 8.0)));
        g.setColor(this.getAppearance().getForeColor());
        g.drawLine((int)this.minSliderX, (int)(this.getY() + this.getHeight() / 2.0), (int)(this.getX() + this.getWidth() - this.getHeight()), (int)(this.getY() + this.getHeight() / 2.0));
        g.setStroke(oldStroke);
        super.render(g);
    }

    @Override
    public void setValueRelativeToMousePosition() {
        double mouseX = Input.mouse().getLocation().getX();
        if (mouseX >= this.minSliderX && mouseX <= this.maxSliderX) {
            double relativeMouseX = mouseX - this.minSliderX;
            double percentage = relativeMouseX / (this.maxSliderX - this.minSliderX);
            this.setCurrentValue((float)((double)this.getMinValue() + percentage * (double)(this.getMaxValue() - this.getMinValue())));
        }
    }
}

