/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.gui.Appearance;
import de.gurkenlabs.litiengine.gui.ComponentMouseEvent;
import de.gurkenlabs.litiengine.gui.ComponentMouseWheelEvent;
import de.gurkenlabs.litiengine.gui.FontLoader;
import de.gurkenlabs.litiengine.gui.GuiProperties;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.sound.Sound;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class GuiComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
IRenderable {
    protected static final Font ICON_FONT;
    private static int componentId;
    private final Appearance appearance;
    private final Appearance hoveredAppearance;
    private final Appearance disabledAppearance;
    private Color textShadowColor;
    private final List<Consumer<ComponentMouseEvent>> clickConsumer;
    private final List<Consumer<ComponentMouseEvent>> hoverConsumer;
    private final List<Consumer<ComponentMouseEvent>> mousePressedConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseEnterConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseLeaveConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseDraggedConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseReleasedConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseMovedConsumer;
    private final List<Consumer<ComponentMouseWheelEvent>> mouseWheelConsumer;
    private final List<GuiComponent> components;
    private final List<Consumer<String>> textChangedConsumer;
    private boolean drawTextShadow = false;
    private boolean forwardMouseEvents = true;
    private Sound hoverSound;
    private final int id;
    private boolean isHovered;
    private boolean isPressed;
    private boolean isSelected;
    private boolean suspended;
    private boolean enabled;
    private Object tag;
    private String text;
    private Align textAlignment = Align.CENTER;
    private int textAngle = 0;
    private double textX;
    private double textY;
    private boolean visible;
    private double width;
    private double height;
    private double x;
    private double y;
    private double xMargin;

    protected GuiComponent(double x, double y) {
        this.components = new CopyOnWriteArrayList<GuiComponent>();
        this.clickConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.hoverConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mousePressedConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseDraggedConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseEnterConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseLeaveConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseReleasedConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseWheelConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseWheelEvent>>();
        this.mouseMovedConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.textChangedConsumer = new CopyOnWriteArrayList<Consumer<String>>();
        this.appearance = new Appearance();
        this.appearance.update(GuiProperties.getDefaultAppearance());
        this.appearance.onChange(app -> {
            for (GuiComponent child : this.getComponents()) {
                child.getAppearance().update(this.getAppearance());
            }
        });
        this.hoveredAppearance = new Appearance();
        this.hoveredAppearance.update(GuiProperties.getDefaultAppearanceHovered());
        this.hoveredAppearance.onChange(app -> {
            for (GuiComponent child : this.getComponents()) {
                child.getAppearanceHovered().update(this.getAppearanceHovered());
            }
        });
        this.disabledAppearance = new Appearance();
        this.disabledAppearance.update(GuiProperties.getDefaultAppearanceDisabled());
        this.appearance.onChange(app -> {
            for (GuiComponent child : this.getComponents()) {
                child.getAppearanceDisabled().update(this.getAppearanceDisabled());
            }
        });
        this.id = ++componentId;
        this.x = x;
        this.y = y;
        this.setTextXMargin(this.getWidth() / 16.0);
        this.setSelected(false);
        this.setEnabled(true);
        this.initializeComponents();
    }

    protected GuiComponent(double x, double y, double width, double height) {
        this(x, y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public boolean drawTextShadow() {
        return this.drawTextShadow;
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public Appearance getAppearanceHovered() {
        return this.hoveredAppearance;
    }

    public Appearance getAppearanceDisabled() {
        return this.disabledAppearance;
    }

    public Rectangle2D getBoundingBox() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public int getComponentId() {
        return this.id;
    }

    public List<GuiComponent> getComponents() {
        return this.components;
    }

    public double getHeight() {
        return this.height;
    }

    public Sound getHoverSound() {
        return this.hoverSound;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public Object getTag() {
        return this.tag;
    }

    public String getText() {
        return this.text;
    }

    public Align getTextAlign() {
        return this.textAlignment;
    }

    public int getTextAngle() {
        return this.textAngle;
    }

    public Color getTextShadowColor() {
        return this.textShadowColor;
    }

    public String getTextToRender(Graphics2D g) {
        if (this.getText() == null) {
            return "";
        }
        FontMetrics fm = g.getFontMetrics();
        String newText = this.getText();
        while (newText.length() > 1 && (double)fm.stringWidth(newText) >= this.getWidth() - this.getTextXMargin()) {
            newText = newText.substring(1, newText.length());
        }
        return newText;
    }

    public double getTextX() {
        return this.textX;
    }

    public double getTextXMargin() {
        return this.xMargin;
    }

    public double getTextY() {
        return this.textY;
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isForwardMouseEvents() {
        return this.forwardMouseEvents;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e)) {
            return;
        }
        if (this.isPressed) {
            ComponentMouseEvent event = new ComponentMouseEvent(e, this);
            this.getClickConsumer().forEach(consumer -> consumer.accept(event));
            this.isPressed = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e)) {
            return;
        }
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getMouseDraggedConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.isForwardMouseEvents()) {
            return;
        }
        if (!this.mouseEventShouldBeForwarded(e)) {
            this.isHovered = false;
            return;
        }
        this.isHovered = true;
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getHoverConsumer().forEach(consumer -> consumer.accept(event));
        if (this.getHoverSound() != null) {
            Game.getSoundEngine().playSound(this.getHoverSound());
        }
        this.getMouseEnterConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isForwardMouseEvents()) {
            return;
        }
        this.isHovered = false;
        this.isPressed = false;
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getMouseLeaveConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e) && this.isHovered()) {
            this.mouseExited(e);
            return;
        }
        if (!this.isHovered()) {
            this.mouseEntered(e);
        }
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getMouseMovedConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e)) {
            return;
        }
        this.isPressed = true;
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getMousePressedConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e)) {
            return;
        }
        this.isPressed = false;
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getClickConsumer().forEach(consumer -> consumer.accept(event));
        this.getMouseReleasedConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.getMouseWheelConsumer().forEach(consumer -> consumer.accept(new ComponentMouseWheelEvent(e, this)));
    }

    public void onClicked(Consumer<ComponentMouseEvent> callback) {
        if (!this.getClickConsumer().contains(callback)) {
            this.getClickConsumer().add(callback);
        }
    }

    public void onHovered(Consumer<ComponentMouseEvent> callback) {
        if (!this.getHoverConsumer().contains(callback)) {
            this.getHoverConsumer().add(callback);
        }
    }

    public void onMouseDragged(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseDraggedConsumer().contains(callback)) {
            this.getMouseDraggedConsumer().add(callback);
        }
    }

    public void onMouseEnter(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseEnterConsumer().contains(callback)) {
            this.getMouseEnterConsumer().add(callback);
        }
    }

    public void onMouseLeave(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseLeaveConsumer().contains(callback)) {
            this.getMouseLeaveConsumer().add(callback);
        }
    }

    public void onMouseMoved(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseMovedConsumer().contains(callback)) {
            this.getMouseMovedConsumer().add(callback);
        }
    }

    public void onMousePressed(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMousePressedConsumer().contains(callback)) {
            this.getMousePressedConsumer().add(callback);
        }
    }

    public void onMouseReleased(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseReleasedConsumer().contains(callback)) {
            this.getMouseReleasedConsumer().add(callback);
        }
    }

    public void onMouseWheelScrolled(Consumer<ComponentMouseWheelEvent> callback) {
        if (!this.getMouseWheelConsumer().contains(callback)) {
            this.getMouseWheelConsumer().add(callback);
        }
    }

    public void onTextChanged(Consumer<String> cons) {
        this.textChangedConsumer.add(cons);
    }

    public void prepare() {
        this.suspended = false;
        this.visible = true;
        Input.mouse().registerMouseListener(this);
        Input.mouse().registerMouseWheelListener(this);
        Input.mouse().registerMouseMotionListener(this);
        for (GuiComponent component : this.getComponents()) {
            component.prepare();
        }
    }

    @Override
    public void render(Graphics2D g) {
        if (this.isSuspended() || !this.isVisible()) {
            return;
        }
        Appearance currentAppearance = this.getAppearance();
        if (this.isHovered()) {
            currentAppearance = this.getAppearanceHovered();
        }
        if (!this.isEnabled()) {
            currentAppearance = this.getAppearanceDisabled();
        }
        if (!currentAppearance.isTransparentBackground()) {
            g.setPaint(currentAppearance.getBackgroundPaint(this.getWidth(), this.getHeight()));
            g.fill(this.getBoundingBox());
        }
        g.setColor(currentAppearance.getForeColor());
        g.setFont(currentAppearance.getFont());
        this.renderText(g);
        for (GuiComponent component : this.getComponents()) {
            if (!component.isVisible() || component.isSuspended()) continue;
            component.render(g);
        }
        if (Game.getConfiguration().debug().renderGuiComponentBoundingBoxes()) {
            g.setColor(Color.RED);
            g.draw(this.getBoundingBox());
        }
    }

    public void setDimension(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        for (GuiComponent comp : this.getComponents()) {
            comp.setEnabled(this.isEnabled());
        }
    }

    public void setForwardMouseEvents(boolean forwardMouseEvents) {
        this.forwardMouseEvents = forwardMouseEvents;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setHovered(boolean hovered) {
        this.isHovered = hovered;
    }

    public void setHoverSound(Sound hoverSound) {
        this.hoverSound = hoverSound;
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setPosition(Point2D newPosition) {
        this.x = newPosition.getX();
        this.y = newPosition.getY();
    }

    public void setSelected(boolean bool) {
        this.isSelected = bool;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public void setText(String text) {
        this.text = text;
        for (Consumer<String> cons : this.textChangedConsumer) {
            cons.accept(this.getText());
        }
        this.setTextX(0.0);
    }

    public void setTextAlignment(Align textAlignment) {
        this.textAlignment = textAlignment;
    }

    public void setTextAngle(int textAngle) {
        this.textAngle = textAngle;
    }

    public void setTextShadow(boolean drawTextShadow) {
        this.drawTextShadow = drawTextShadow;
        for (GuiComponent comp : this.getComponents()) {
            comp.setTextShadow(drawTextShadow);
        }
    }

    public void setTextShadowColor(Color textShadowColor) {
        this.textShadowColor = textShadowColor;
    }

    public void setTextX(double x) {
        this.textX = x;
    }

    public void setTextXMargin(double xMargin) {
        this.xMargin = xMargin;
    }

    public void setTextY(double y) {
        this.textY = y;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        for (GuiComponent component : this.getComponents()) {
            component.setVisible(visible);
        }
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void suspend() {
        Input.mouse().unregisterMouseListener(this);
        Input.mouse().unregisterMouseWheelListener(this);
        Input.mouse().unregisterMouseMotionListener(this);
        this.suspended = true;
        this.visible = false;
        for (GuiComponent childComp : this.getComponents()) {
            childComp.suspend();
        }
    }

    public void toggleSelection() {
        this.setSelected(!this.isSelected);
    }

    protected List<Consumer<ComponentMouseEvent>> getClickConsumer() {
        return this.clickConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getHoverConsumer() {
        return this.hoverConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseDraggedConsumer() {
        return this.mouseDraggedConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseEnterConsumer() {
        return this.mouseEnterConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseLeaveConsumer() {
        return this.mouseLeaveConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseMovedConsumer() {
        return this.mouseMovedConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMousePressedConsumer() {
        return this.mousePressedConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseReleasedConsumer() {
        return this.mouseReleasedConsumer;
    }

    protected List<Consumer<ComponentMouseWheelEvent>> getMouseWheelConsumer() {
        return this.mouseWheelConsumer;
    }

    protected void initializeComponents() {
    }

    protected boolean mouseEventShouldBeForwarded(MouseEvent e) {
        return this.isForwardMouseEvents() && this.isVisible() && this.isEnabled() && !this.isSuspended() && e != null && this.getBoundingBox().contains(e.getPoint());
    }

    private void renderText(Graphics2D g) {
        double defaultTextX;
        if (this.getText() == null || this.getText().isEmpty()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        double defaultTextY = (double)fm.getAscent() + (this.getHeight() - (double)(fm.getAscent() + fm.getDescent())) / 2.0;
        switch (this.getTextAlign()) {
            case LEFT: {
                defaultTextX = this.getTextXMargin();
                break;
            }
            case RIGHT: {
                defaultTextX = this.getWidth() - this.getTextXMargin() - (double)fm.stringWidth(this.getTextToRender(g));
                break;
            }
            default: {
                defaultTextX = this.getWidth() / 2.0 - (double)fm.stringWidth(this.getTextToRender(g)) / 2.0;
            }
        }
        if (this.getTextY() == 0.0) {
            this.setTextY(defaultTextY);
        }
        if (this.getTextX() == 0.0) {
            this.setTextX(defaultTextX);
        }
        if (this.getTextAngle() == 0) {
            if (this.drawTextShadow()) {
                RenderEngine.drawTextWithShadow(g, this.getTextToRender(g), this.getX() + this.getTextX(), this.getY() + this.getTextY(), this.getTextShadowColor());
            } else {
                RenderEngine.drawText(g, this.getTextToRender(g), this.getX() + this.getTextX(), this.getY() + this.getTextY());
            }
        } else if (this.getTextAngle() == 90) {
            RenderEngine.drawRotatedText(g, this.getX() + this.getTextX(), this.getY() + this.getTextY() - (double)fm.stringWidth(this.getTextToRender(g)), this.getTextAngle(), this.getTextToRender(g));
        } else {
            RenderEngine.drawRotatedText(g, this.getX() + this.getTextX(), this.getY() + this.getTextY(), this.getTextAngle(), this.getTextToRender(g));
        }
    }

    static {
        componentId = 0;
        Font icon = FontLoader.load("fontello.ttf");
        ICON_FONT = icon != null ? icon.deriveFont(16.0f) : null;
    }
}

