/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FontLoader {
    private static final HashMap<String, Font> fonts = new HashMap();
    private static final Logger log = Logger.getLogger(FontLoader.class.getName());

    private FontLoader() {
    }

    public static Font load(String fontName) {
        String[] f;
        if (fonts.containsKey(fontName)) {
            return fonts.get(fontName);
        }
        for (String font : f = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            String name = FileUtilities.getFileName(fontName);
            if (!font.equals(name)) continue;
            return new Font(name, 0, 8);
        }
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            InputStream fontStream = FileUtilities.getGameResource(fontName);
            if (fontStream == null) {
                log.log(Level.SEVERE, "font {0} could not be loaded", fontName);
            }
            Font font = Font.createFont(0, fontStream);
            ge.registerFont(font);
            fonts.put(fontName, font);
            return font;
        }
        catch (FontFormatException | IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

