/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.JPanel;

public class Appearance {
    private final List<Consumer<Appearance>> changedConsumer = new CopyOnWriteArrayList<Consumer<Appearance>>();
    private Color foreColor;
    private Color backgroundColor1;
    private Color backgroundColor2;
    private Font font = new JPanel().getFont();
    private boolean horizontalBackgroundGradient;
    private boolean transparentBackground;

    public Appearance() {
    }

    public Appearance(Color foreColor) {
        this();
        this.foreColor = foreColor;
        this.setTransparentBackground(true);
    }

    public Appearance(Color foreColor, Color backColor) {
        this();
        this.foreColor = foreColor;
        this.backgroundColor1 = backColor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Appearance) {
            return this.hashCode() == obj.hashCode();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getForeColor(), this.getBackgroundColor1(), this.getBackgroundColor2(), this.isHorizontalBackgroundGradient(), this.isTransparentBackground(), this.getFont());
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public Color getBackgroundColor1() {
        return this.backgroundColor1;
    }

    public Color getBackgroundColor2() {
        return this.backgroundColor2;
    }

    public Paint getBackgroundPaint(double width, double height) {
        if (this.isTransparentBackground()) {
            return null;
        }
        if (this.backgroundColor2 == null) {
            return this.backgroundColor1;
        }
        if (this.horizontalBackgroundGradient) {
            return new GradientPaint(0.0f, 0.0f, this.backgroundColor1, (float)(width / 2.0), 0.0f, this.backgroundColor2);
        }
        return new GradientPaint(0.0f, 0.0f, this.backgroundColor1, 0.0f, (float)(height / 2.0), this.backgroundColor2);
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isHorizontalBackgroundGradient() {
        return this.horizontalBackgroundGradient;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setForeColor(Color foreColor) {
        this.foreColor = foreColor;
        this.fireOnChangeEvent();
    }

    public void setBackgroundColor1(Color backColor1) {
        this.backgroundColor1 = backColor1;
        this.fireOnChangeEvent();
    }

    public void setBackgroundColor2(Color backColor2) {
        this.backgroundColor2 = backColor2;
        this.fireOnChangeEvent();
    }

    public void setFont(Font font) {
        this.font = font;
        this.fireOnChangeEvent();
    }

    public void setFontSize(float size) {
        this.font = this.font.deriveFont(size);
        this.fireOnChangeEvent();
    }

    public void setHorizontalBackgroundGradient(boolean horizontal) {
        this.horizontalBackgroundGradient = horizontal;
        this.fireOnChangeEvent();
    }

    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
        this.fireOnChangeEvent();
    }

    public void onChange(Consumer<Appearance> cons) {
        this.changedConsumer.add(cons);
    }

    public void update(Appearance updateAppearance) {
        this.setBackgroundColor1(updateAppearance.getBackgroundColor1());
        this.setBackgroundColor2(updateAppearance.getBackgroundColor2());
        this.setForeColor(updateAppearance.getForeColor());
        this.setHorizontalBackgroundGradient(updateAppearance.isHorizontalBackgroundGradient());
        this.setTransparentBackground(updateAppearance.isTransparentBackground());
        this.setFont(updateAppearance.getFont());
    }

    private void fireOnChangeEvent() {
        for (Consumer<Appearance> cons : this.changedConsumer) {
            cons.accept(this);
        }
    }
}

