/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.particles.emitters;

import de.gurkenlabs.litiengine.annotation.EmitterInfo;
import de.gurkenlabs.litiengine.annotation.EntityInfo;
import de.gurkenlabs.litiengine.graphics.particles.Emitter;
import de.gurkenlabs.litiengine.graphics.particles.Particle;
import de.gurkenlabs.litiengine.graphics.particles.ShimmerParticle;
import java.awt.Color;
import java.util.Random;

@EntityInfo(width=64.0f, height=64.0f)
@EmitterInfo(maxParticles=10, spawnAmount=10, spawnRate=10, activateOnInit=true)
public class ShimmerEmitter
extends Emitter {
    public ShimmerEmitter(double originX, double originY) {
        super(originX, originY);
    }

    @Override
    public Particle createNewParticle() {
        Random rand = new Random();
        float x = rand.nextInt((int)this.getWidth());
        float y = rand.nextInt((int)this.getHeight());
        float randX = rand.nextFloat();
        float dx = Math.random() >= 0.5 ? -randX : randX;
        float dy = Math.random() >= 0.5 ? -randX : randX;
        byte size = (byte)(rand.nextInt(3) + 2);
        Color color = new Color(255, 255, 255, new Random().nextInt(155) + 100);
        if ((double)rand.nextFloat() > 0.5) {
            color = new Color(170, 255, 255, new Random().nextInt(155) + 100);
        }
        return new ShimmerParticle(this.getBoundingBox(), (float)size, size, color).setX(x).setY(y).setDeltaX(dx).setDeltaY(dy);
    }
}

