/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.particles;

import de.gurkenlabs.litiengine.graphics.particles.RectangleFillParticle;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ShimmerParticle
extends RectangleFillParticle {
    private final Rectangle2D boundingBox;

    public ShimmerParticle(Rectangle2D boundingBox, float width, float height, Color color) {
        super(width, height, color, 0);
        this.boundingBox = boundingBox;
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public void update(Point2D emitterOrigin, float updateRateFactor) {
        super.update(emitterOrigin, updateRateFactor);
        Point2D.Double emitterLocation = new Point2D.Double(this.getBoundingBox().getX(), this.getBoundingBox().getY());
        Point2D relativeParticleLocation = this.getRelativeLocation(emitterLocation);
        if (relativeParticleLocation.getX() < this.getBoundingBox().getX()) {
            this.setDeltaX(-this.getDx());
        }
        if (relativeParticleLocation.getX() > this.getBoundingBox().getX() + this.getBoundingBox().getWidth()) {
            this.setDeltaX(-this.getDx());
        }
        if (relativeParticleLocation.getY() < this.getBoundingBox().getY()) {
            this.setDeltaY(-this.getDy());
        }
        if (relativeParticleLocation.getY() > this.getBoundingBox().getY() + this.getBoundingBox().getHeight()) {
            this.setDeltaY(-this.getDy());
        }
    }
}

