/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.particles;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ITimeToLive;
import de.gurkenlabs.litiengine.physics.CollisionType;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Particle
implements ITimeToLive {
    private long aliveTick;
    private long aliveTime;
    private CollisionType collisionType;
    private Color color;
    private int colorAlpha = 255;
    private float deltaHeight;
    private float deltaWidth;
    private float deltaX;
    private float deltaY;
    private float gravityX;
    private float gravityY;
    private float height;
    private final int timeToLive;
    private float width;
    private float x;
    private float y;
    private ParticleRenderType particleRenderType;

    public Particle(float width, float height, Color color, int ttl) {
        this.setParticleRenderType(ParticleRenderType.EMITTER);
        this.setWidth(width);
        this.setHeight(height);
        this.timeToLive = ttl;
        this.color = color;
        this.colorAlpha = this.color.getAlpha();
        this.collisionType = CollisionType.NONE;
    }

    @Override
    public long getAliveTime() {
        return this.aliveTime;
    }

    public Rectangle2D getBoundingBox(Point2D origin) {
        return new Rectangle2D.Double(origin.getX() + (double)this.getX(), origin.getY() + (double)this.getY(), this.getWidth(), this.getHeight());
    }

    public CollisionType getCollisionType() {
        return this.collisionType;
    }

    public Color getColor() {
        return this.color;
    }

    public int getColorAlpha() {
        return this.colorAlpha;
    }

    public float getDeltaHeight() {
        return this.deltaHeight;
    }

    public float getDeltaWidth() {
        return this.deltaWidth;
    }

    public float getDx() {
        return this.deltaX;
    }

    public float getDy() {
        return this.deltaY;
    }

    public float getGravityX() {
        return this.gravityX;
    }

    public float getGravityY() {
        return this.gravityY;
    }

    public float getHeight() {
        return this.height;
    }

    public Point2D getLocation(Point2D effectLocation) {
        Point2D newEffectLocation = Game.getScreenManager() != null ? Game.getCamera().getViewPortLocation(effectLocation) : effectLocation;
        return this.getRelativeLocation(newEffectLocation);
    }

    public ParticleRenderType getParticleRenderType() {
        return this.particleRenderType;
    }

    @Override
    public int getTimeToLive() {
        return this.timeToLive;
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public abstract void render(Graphics2D var1, Point2D var2);

    public Particle setCollisionType(CollisionType collisionType) {
        this.collisionType = collisionType;
        return this;
    }

    public Particle setColor(Color color) {
        this.color = color;
        return this;
    }

    public Particle setColorAlpha(int colorAlpha) {
        if (colorAlpha < 0 || colorAlpha > 100) {
            return this;
        }
        this.colorAlpha = colorAlpha;
        return this;
    }

    public Particle setDeltaHeight(float deltaHeight) {
        this.deltaHeight = deltaHeight;
        return this;
    }

    public Particle setDeltaIncX(float gravityX) {
        this.gravityX = gravityX;
        return this;
    }

    public Particle setDeltaIncY(float gravityY) {
        this.gravityY = gravityY;
        return this;
    }

    public Particle setDeltaWidth(float deltaWidth) {
        this.deltaWidth = deltaWidth;
        return this;
    }

    public Particle setDeltaX(float dx) {
        this.deltaX = dx;
        return this;
    }

    public Particle setDeltaY(float dy) {
        this.deltaY = dy;
        return this;
    }

    public Particle setHeight(float height) {
        this.height = height;
        return this;
    }

    public Particle setParticleRenderType(ParticleRenderType particleRenderType) {
        this.particleRenderType = particleRenderType;
        return this;
    }

    public Particle setWidth(float width) {
        this.width = width;
        return this;
    }

    public Particle setX(float x) {
        this.x = x;
        return this;
    }

    public Particle setY(float y) {
        this.y = y;
        return this;
    }

    @Override
    public boolean timeToLiveReached() {
        return this.getTimeToLive() > 0 && this.getAliveTime() >= (long)this.getTimeToLive();
    }

    public void update(Point2D emitterOrigin, float updateRatio) {
        if (this.aliveTick == 0L) {
            this.aliveTick = Game.getLoop().getTicks();
        }
        this.aliveTime = Game.getLoop().getDeltaTime(this.aliveTick);
        if (this.timeToLiveReached()) {
            return;
        }
        int alpha = this.getTimeToLive() > 0 ? (int)((double)((long)this.getTimeToLive() - this.getAliveTime()) / (double)this.getTimeToLive() * (double)this.getColorAlpha()) : this.getColorAlpha();
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), alpha >= 0 ? alpha : 0);
        if (this.getCollisionType() != CollisionType.NONE && Game.getPhysicsEngine() != null && Game.getPhysicsEngine().collides(this.getBoundingBox(emitterOrigin), this.getCollisionType())) {
            return;
        }
        if (this.getDx() != 0.0f) {
            this.x += this.getDx() * updateRatio;
        }
        if (this.getDy() != 0.0f) {
            this.y += this.getDy() * updateRatio;
        }
        if (this.getGravityX() != 0.0f) {
            this.deltaX += this.getGravityX() * updateRatio;
        }
        if (this.getGravityY() != 0.0f) {
            this.deltaY += this.getGravityY() * updateRatio;
        }
        if (this.getDeltaWidth() != 0.0f) {
            this.width += this.getDeltaWidth() * updateRatio;
        }
        if (this.getDeltaHeight() != 0.0f) {
            this.height += this.getDeltaHeight() * updateRatio;
        }
    }

    protected Point2D getRelativeLocation(Point2D effectLocation) {
        return new Point2D.Float(this.getRelativeX(effectLocation.getX()), this.getRelativeY(effectLocation.getY()));
    }

    protected float getRelativeX(double effectLocationX) {
        return (float)(effectLocationX + (double)this.getX() - (double)this.getWidth() / 2.0);
    }

    protected float getRelativeY(double effectLocationY) {
        return (float)(effectLocationY + (double)this.getY() - (double)this.getHeight() / 2.0);
    }

    public static enum ParticleRenderType {
        NONE,
        EMITTER,
        GROUND,
        OVERLAY;

    }
}

