/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.particles;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ITimeToLive;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.annotation.CollisionInfo;
import de.gurkenlabs.litiengine.annotation.EmitterInfo;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.graphics.DebugRenderer;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.particles.Particle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@CollisionInfo(collision=false)
public abstract class Emitter
extends Entity
implements IUpdateable,
ITimeToLive,
IRenderable {
    public static final Color DEFAULT_PARTICLE_COLOR = new Color(255, 255, 255, 150);
    public static final int DEFAULT_UPDATERATE = 30;
    public static final int DEFAULT_SPAWNAMOUNT = 1;
    public static final int DEFAULT_MAXPARTICLES = 100;
    private static final Random RANDOM = new Random();
    private final List<Consumer<Emitter>> finishedConsumer;
    private boolean activated;
    private final boolean activateOnInit;
    private long activationTick;
    private long aliveTime;
    private final List<Color> colors = new ArrayList<Color>();
    private long lastSpawn;
    private int maxParticles;
    private int particleMaxTTL;
    private int particleMinTTL;
    private final CopyOnWriteArrayList<Particle> particles;
    private int particleUpdateDelay;
    private boolean paused;
    private int spawnAmount;
    private int spawnRate;
    private int timeToLive;
    private IRenderable groundRenderable;
    private IRenderable overlayRenderable;

    public Emitter() {
        this.finishedConsumer = new CopyOnWriteArrayList<Consumer<Emitter>>();
        this.particles = new CopyOnWriteArrayList();
        this.groundRenderable = g -> this.renderParticles(g, Particle.ParticleRenderType.GROUND);
        this.overlayRenderable = g -> this.renderParticles(g, Particle.ParticleRenderType.OVERLAY);
        EmitterInfo info = this.getClass().getAnnotation(EmitterInfo.class);
        if (info != null) {
            this.maxParticles = info.maxParticles();
            this.spawnAmount = info.spawnAmount();
            this.spawnRate = info.spawnRate();
            this.timeToLive = info.emitterTTL();
            this.particleMinTTL = info.particleMinTTL();
            this.particleMaxTTL = info.particleMaxTTL();
            this.particleUpdateDelay = info.particleUpdateRate();
            this.activateOnInit = info.activateOnInit();
        } else {
            this.maxParticles = 100;
            this.spawnAmount = 1;
            this.spawnRate = 0;
            this.timeToLive = 0;
            this.particleMinTTL = 0;
            this.particleMaxTTL = 0;
            this.particleUpdateDelay = 30;
            this.activateOnInit = true;
        }
    }

    public Emitter(double originX, double originY) {
        this(new Point2D.Double(originX, originY));
    }

    public Emitter(Point2D origin) {
        this();
        this.setLocation(origin);
    }

    public void activate() {
        if (this.activated) {
            return;
        }
        this.activated = true;
        this.activationTick = Game.getLoop().getTicks();
        Game.getLoop().attach(this);
    }

    public void addParticle(Particle particle) {
        this.particles.add(particle);
    }

    public void deactivate() {
        if (!this.activated) {
            return;
        }
        this.activated = false;
        this.getParticles().clear();
        this.aliveTime = 0L;
        this.activationTick = 0L;
        this.lastSpawn = 0L;
        Game.getLoop().detach(this);
    }

    public void delete() {
        this.deactivate();
        if (Game.getEnvironment() != null) {
            Game.getEnvironment().remove(this);
        }
    }

    @Override
    public long getAliveTime() {
        return this.aliveTime;
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public IRenderable getGroundRenderable() {
        return this.groundRenderable;
    }

    public Point2D getOrigin() {
        return this.getLocation();
    }

    public IRenderable getOverlayRenderable() {
        return this.overlayRenderable;
    }

    public int getMaxParticles() {
        return this.maxParticles;
    }

    public int getParticleMaxTTL() {
        return this.particleMaxTTL;
    }

    public int getParticleMinTTL() {
        return this.particleMinTTL;
    }

    public void getParticleMinTTL(int minTTL) {
        this.particleMinTTL = minTTL;
    }

    public List<Particle> getParticles() {
        return this.particles;
    }

    public int getParticleUpdateRate() {
        return this.particleUpdateDelay;
    }

    public int getSpawnAmount() {
        return this.spawnAmount;
    }

    public int getSpawnRate() {
        return this.spawnRate;
    }

    @Override
    public int getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isActivateOnInit() {
        return this.activateOnInit;
    }

    public boolean isFinished() {
        return this.getTimeToLive() > 0 && this.timeToLiveReached() || this.activated && this.lastSpawn > 0L && this.getParticles().isEmpty();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void onFinished(Consumer<Emitter> cons) {
        this.finishedConsumer.add(cons);
    }

    @Override
    public void render(Graphics2D g) {
        if (Game.getScreenManager() != null && Game.getCamera() != null && !Game.getCamera().getViewPort().intersects(this.getBoundingBox())) {
            return;
        }
        this.renderParticles(g, Particle.ParticleRenderType.EMITTER);
        if (Game.getConfiguration().debug().renderHitBoxes()) {
            DebugRenderer.renderEntityDebugInfo(g, this);
        }
    }

    public void setColors(Color ... colors) {
        this.colors.clear();
        this.colors.addAll(Arrays.asList(colors));
    }

    public void setMaxParticles(int maxPart) {
        this.maxParticles = maxPart;
    }

    public void setParticleMaxTTL(int maxTTL) {
        this.particleMaxTTL = maxTTL;
    }

    public void setParticleMinTTL(int minTTL) {
        this.particleMinTTL = minTTL;
    }

    public void setParticleUpdateRate(int delay) {
        this.particleUpdateDelay = delay;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setSpawnAmount(int spawnAmount) {
        this.spawnAmount = spawnAmount;
    }

    public void setSpawnRate(int spawnRate) {
        this.spawnRate = spawnRate;
    }

    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    @Override
    public boolean timeToLiveReached() {
        return this.activated && this.getTimeToLive() > 0 && this.getAliveTime() >= (long)this.getTimeToLive();
    }

    public void togglePaused() {
        this.paused = !this.paused;
    }

    @Override
    public void update() {
        if (this.isPaused()) {
            return;
        }
        if (this.isFinished()) {
            for (Consumer<Emitter> cons : this.finishedConsumer) {
                cons.accept(this);
            }
            this.delete();
            return;
        }
        float updateRatio = (float)this.getParticleUpdateRate() / (float)Game.getLoop().getUpdateRate();
        for (Particle p : this.getParticles().stream().collect(Collectors.toList())) {
            if (this.particleCanBeRemoved(p)) {
                this.particles.remove(p);
                continue;
            }
            p.update(this.getOrigin(), updateRatio);
        }
        this.aliveTime = Game.getLoop().getDeltaTime(this.activationTick);
        if (this.getSpawnRate() == 0 || Game.getLoop().getDeltaTime(this.lastSpawn) >= (long)this.getSpawnRate()) {
            this.spawnParticle();
        }
    }

    protected void addParticleColor(Color ... colors) {
        for (Color color : colors) {
            if (this.colors.contains(color)) continue;
            this.colors.add(color);
        }
    }

    protected boolean canTakeNewParticles() {
        return this.particles.size() < this.maxParticles;
    }

    protected abstract Particle createNewParticle();

    protected Color getRandomParticleColor() {
        if (this.colors.isEmpty()) {
            return DEFAULT_PARTICLE_COLOR;
        }
        return this.colors.get(RANDOM.nextInt(this.colors.size()));
    }

    protected int getRandomParticleTTL() {
        if (this.getParticleMaxTTL() == 0) {
            return this.getParticleMinTTL();
        }
        int ttlDiff = this.getParticleMaxTTL() - this.getParticleMinTTL();
        if (ttlDiff <= 0) {
            return this.getParticleMaxTTL();
        }
        return RANDOM.nextInt(this.getParticleMaxTTL() - this.getParticleMinTTL()) + this.getParticleMinTTL();
    }

    protected int getRandomParticleX() {
        return RANDOM.nextInt((int)this.getWidth());
    }

    protected int getRandomParticleY() {
        return RANDOM.nextInt((int)this.getHeight());
    }

    protected boolean particleCanBeRemoved(Particle particle) {
        return particle.timeToLiveReached();
    }

    protected void spawnParticle() {
        for (int i = 0; i < this.getSpawnAmount(); i = (int)((short)(i + 1))) {
            if (!this.canTakeNewParticles()) {
                return;
            }
            Particle part = this.createNewParticle();
            if (part == null) continue;
            this.addParticle(part);
        }
    }

    private void renderParticles(Graphics2D g, Particle.ParticleRenderType renderType) {
        Point2D origin = this.getOrigin();
        this.particles.forEach(particle -> {
            if (particle.getParticleRenderType() == renderType) {
                particle.render(g, origin);
            }
        });
    }
}

