/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.graphics.ColorLayer;
import de.gurkenlabs.litiengine.graphics.StaticShadow;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;

public class StaticShadowLayer
extends ColorLayer {
    public StaticShadowLayer(IEnvironment env, int alpha, Color color) {
        super(env, color, alpha);
    }

    @Override
    protected void renderLayer(Graphics2D g) {
        Color colorWithAlpha = this.getColorWithAlpha();
        g.setColor(colorWithAlpha);
        Area ar = new Area();
        for (StaticShadow staticShadow : this.getEnvironment().getStaticShadows()) {
            if (staticShadow.getShadowType() == StaticShadowType.NONE) continue;
            Area staticShadowArea = staticShadow.getArea();
            ar.add(staticShadowArea);
        }
        g.fill(ar);
    }

    @Override
    protected String getCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getColor());
        sb.append(this.getAlpha());
        for (StaticShadow shadow : this.getEnvironment().getStaticShadows()) {
            sb.append((Object)shadow.getShadowType());
            sb.append(shadow.getLocation());
            sb.append(shadow.getWidth());
            sb.append(shadow.getHeight());
        }
        sb.append(this.getEnvironment().getMap().getSizeInPixels());
        int key = sb.toString().hashCode();
        return "staticshadow-" + this.getEnvironment().getMap().getFileName() + "-" + Integer.toString(key);
    }
}

