/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.annotation.EntityInfo;
import de.gurkenlabs.litiengine.entities.CollisionBox;
import de.gurkenlabs.litiengine.environment.tilemap.MapArea;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

@EntityInfo(renderType=RenderType.OVERLAY)
public class StaticShadow
extends MapArea {
    public static final int DEFAULT_ALPHA = 75;
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final int DEFAULT_OFFSET = 10;
    private final CollisionBox origin;
    private StaticShadowType shadowType;
    private int shadowOffset;
    private Area area;

    public StaticShadow(StaticShadowType shadowType) {
        this.shadowType = shadowType;
        this.shadowOffset = 10;
        this.origin = null;
    }

    public StaticShadow(double x, double y, float width, float height, StaticShadowType shadowType) {
        this(0, null, x, y, width, height, shadowType);
    }

    public StaticShadow(int id, double x, double y, float width, float height, StaticShadowType shadowType) {
        this(id, null, x, y, width, height, shadowType);
    }

    public StaticShadow(int id, String name, double x, double y, float width, float height, StaticShadowType shadowType) {
        super(id, name, x, y, width, height);
        this.setShadowType(shadowType);
        this.origin = null;
        this.shadowOffset = 10;
    }

    public StaticShadow(CollisionBox box) {
        super(0, null, box.getLocation().getX(), box.getLocation().getY(), box.getWidth(), box.getHeight());
        this.setShadowType(StaticShadowType.NONE);
        this.origin = box;
        this.shadowOffset = 10;
    }

    public StaticShadowType getShadowType() {
        return this.shadowType;
    }

    public void setShadowType(StaticShadowType shadowType) {
        this.shadowType = shadowType;
        this.area = null;
    }

    @Override
    public void setX(double x) {
        super.setX(x);
        this.area = null;
    }

    @Override
    public void setY(double y) {
        super.setY(y);
        this.area = null;
    }

    @Override
    public void setWidth(float width) {
        super.setWidth(width);
        this.area = null;
    }

    @Override
    public void setHeight(float height) {
        super.setHeight(height);
        this.area = null;
    }

    @Override
    public void setLocation(Point2D location) {
        super.setLocation(location);
        this.area = null;
    }

    public CollisionBox getOrigin() {
        return this.origin;
    }

    @Override
    public String toString() {
        if (this.getOrigin() == null) {
            return super.toString();
        }
        return "[" + this.getOrigin().toString() + "] -> " + super.toString();
    }

    public Area getArea() {
        if (this.getShadowType() == StaticShadowType.NONE) {
            return null;
        }
        if (this.area == null) {
            this.createArea();
        }
        return this.area;
    }

    private void createArea() {
        if (this.getShadowType() == StaticShadowType.NONE) {
            return;
        }
        Path2D.Double parallelogram = new Path2D.Double();
        if (this.shadowType.equals((Object)StaticShadowType.DOWN)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight() + (double)this.getOffset());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.DOWNLEFT)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth() - (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight() + (double)this.getOffset());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.DOWNRIGHT)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth() + (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight() + (double)this.getOffset());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.LEFT)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth() - (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX() - (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.LEFTDOWN)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX() - (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.LEFTRIGHT)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth() + (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX() - (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.RIGHTLEFT)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth() - (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.RIGHT)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth() + (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.RIGHTDOWN)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getOffset() / 2.0, this.getY() + (double)this.getHeight() + (double)this.getOffset());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight());
            parallelogram.closePath();
        } else if (this.shadowType.equals((Object)StaticShadowType.NOOFFSET)) {
            ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY());
            ((Path2D)parallelogram).lineTo(this.getX() + (double)this.getWidth(), this.getY() + (double)this.getHeight());
            ((Path2D)parallelogram).lineTo(this.getX(), this.getY() + (double)this.getHeight());
            parallelogram.closePath();
        }
        this.area = new Area(parallelogram);
    }

    public int getOffset() {
        return this.shadowOffset;
    }

    public void setOffset(int shadowOffset) {
        this.shadowOffset = shadowOffset;
        this.area = null;
    }
}

