/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Resources;
import de.gurkenlabs.litiengine.SpriteSheetInfo;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.graphics.ImageCache;
import de.gurkenlabs.litiengine.graphics.ImageFormat;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class Spritesheet {
    private static final Map<String, int[]> customKeyFrameDurations = new ConcurrentHashMap<String, int[]>();
    private static final Map<String, Spritesheet> spritesheets = new ConcurrentHashMap<String, Spritesheet>();
    private static final Logger log = Logger.getLogger(Spritesheet.class.getName());
    private static final String SPRITE_INFO_COMMENT_CHAR = "#";
    private final List<Integer> emptySprites = new CopyOnWriteArrayList<Integer>();
    private final int hashCode;
    private final BufferedImage image;
    private final String name;
    private final ImageFormat imageFormat;
    private int columns;
    private int rows;
    private int spriteHeight;
    private int spriteWidth;

    private Spritesheet(BufferedImage image, String path, int spriteWidth, int spriteHeight) {
        this.image = image;
        this.name = FileUtilities.getFileName(path);
        this.spriteWidth = spriteWidth;
        this.spriteHeight = spriteHeight;
        this.imageFormat = ImageFormat.get(FileUtilities.getExtension(path));
        this.hashCode = this.getName().hashCode();
        this.updateRowsAndCols();
        spritesheets.put(this.name.toLowerCase(), this);
        ImageCache.SPRITES.onCleared(cache -> this.emptySprites.clear());
    }

    private Spritesheet(ITileset tileset) {
        this(Resources.getImage(tileset.getImage().getAbsoluteSourcePath(), true), tileset.getImage().getSource(), tileset.getTileDimension().width, tileset.getTileDimension().height);
    }

    private Spritesheet(String path, int spriteWidth, int spriteHeight) {
        this(Resources.getImage(path, true), path, spriteWidth, spriteHeight);
    }

    public static Collection<Spritesheet> getSpritesheets() {
        return spritesheets.values();
    }

    public static Spritesheet find(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String name = FileUtilities.getFileName(path).toLowerCase();
        if (!spritesheets.containsKey(name)) {
            return null;
        }
        return spritesheets.get(name);
    }

    public static Collection<Spritesheet> find(Predicate<Spritesheet> pred) {
        if (pred == null) {
            return new ArrayList<Spritesheet>();
        }
        return spritesheets.values().stream().filter(pred).collect(Collectors.toList());
    }

    public static int[] getCustomKeyFrameDurations(String name) {
        if (customKeyFrameDurations.containsKey(FileUtilities.getFileName(name).toLowerCase())) {
            return customKeyFrameDurations.get(FileUtilities.getFileName(name).toLowerCase());
        }
        return new int[0];
    }

    public static int[] getCustomKeyFrameDurations(Spritesheet sprite) {
        return Spritesheet.getCustomKeyFrameDurations(sprite.getName());
    }

    public static Spritesheet load(BufferedImage image, String path, int spriteWidth, int spriteHeight) {
        return new Spritesheet(image, path, spriteWidth, spriteHeight);
    }

    public static Spritesheet load(ITileset tileset) {
        if (tileset == null || tileset.getImage() == null) {
            return null;
        }
        if (tileset.getImage().getAbsoluteSourcePath() == null) {
            return null;
        }
        return new Spritesheet(tileset);
    }

    public static Spritesheet load(SpriteSheetInfo info) {
        Spritesheet sprite = null;
        if (info.getImage() == null || info.getImage().isEmpty()) {
            log.log(Level.SEVERE, "Sprite {0} could not be loaded because no image is defined.", new Object[]{info.getName()});
            return null;
        }
        sprite = Spritesheet.load(ImageProcessing.decodeToImage(info.getImage()), info.getName(), info.getWidth(), info.getHeight());
        if (info.getKeyframes() != null && info.getKeyframes().length > 0) {
            customKeyFrameDurations.put(sprite.getName().toLowerCase(), info.getKeyframes());
        }
        return sprite;
    }

    public static List<Spritesheet> load(String spriteInfoFile) {
        ArrayList<Spritesheet> sprites = new ArrayList<Spritesheet>();
        InputStream fileStream = FileUtilities.getGameResource(spriteInfoFile);
        if (fileStream == null) {
            return sprites;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fileStream));){
            String line;
            while ((line = br.readLine()) != null) {
                List<String> items;
                String[] parts;
                if (line.isEmpty() || line.startsWith(SPRITE_INFO_COMMENT_CHAR) || (parts = line.split(";")).length == 0 || (items = Arrays.asList(parts[0].split("\\s*,\\s*"))).size() < 3) continue;
                Spritesheet.getSpriteSheetFromSpriteInfoLine(FileUtilities.getParentDirPath(spriteInfoFile), sprites, items, parts);
            }
            log.log(Level.INFO, "{0} spritesheets loaded from {1}", new Object[]{sprites.size(), spriteInfoFile});
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return sprites;
    }

    public static Spritesheet load(String path, int spriteWidth, int spriteHeight) {
        return new Spritesheet(path, spriteWidth, spriteHeight);
    }

    public static void remove(String path) {
        spritesheets.values().removeIf(x -> x.getName().equals(path));
        customKeyFrameDurations.remove(path);
    }

    public int getColumns() {
        return this.columns;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public ImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public String getName() {
        return this.name;
    }

    public int getRows() {
        return this.rows;
    }

    public BufferedImage getSprite(int index) {
        if (this.emptySprites.contains(index)) {
            return null;
        }
        String imageCacheKey = MessageFormat.format("{0}_{1}", this.hashCode, index);
        if (ImageCache.SPRITES.containsKey(imageCacheKey)) {
            return ImageCache.SPRITES.get(imageCacheKey);
        }
        if (this.getImage() == null) {
            log.warning("no image defined for sprite '" + this.getName() + "'");
            return null;
        }
        Point position = this.getLocation(index);
        try {
            BufferedImage smallImage = this.getImage().getSubimage(position.x, position.y, this.spriteWidth, this.spriteHeight);
            if (ImageProcessing.isEmpty(smallImage)) {
                this.emptySprites.add(index);
                return null;
            }
            ImageCache.SPRITES.put(imageCacheKey, smallImage);
            return smallImage;
        }
        catch (RasterFormatException rfe) {
            log.warning("could not read sprite of size [" + this.spriteWidth + "x" + this.spriteHeight + " at position [" + position.x + "," + position.y + "] from sprite'" + this.getName() + "'");
            return null;
        }
    }

    public int getSpriteHeight() {
        return this.spriteHeight;
    }

    public int getSpriteWidth() {
        return this.spriteWidth;
    }

    public int getTotalNumberOfSprites() {
        return this.getRows() * this.getColumns();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof Spritesheet) {
            return object.hashCode() == this.hashCode();
        }
        return super.equals(object);
    }

    public void setSpriteHeight(int spriteHeight) {
        this.spriteHeight = spriteHeight;
        this.updateRowsAndCols();
    }

    public void setSpriteWidth(int spriteWidth) {
        this.spriteWidth = spriteWidth;
        this.updateRowsAndCols();
    }

    private static void getSpriteSheetFromSpriteInfoLine(String baseDirectory, ArrayList<Spritesheet> sprites, List<String> items, String[] parts) {
        try {
            List<String> keyFrameStrings;
            String name = baseDirectory + items.get(0);
            int width = Integer.parseInt(items.get(1));
            int height = Integer.parseInt(items.get(2));
            Spritesheet sprite = Spritesheet.load(name, width, height);
            sprites.add(sprite);
            if (parts.length >= 2 && !(keyFrameStrings = Arrays.asList(parts[1].split("\\s*,\\s*"))).isEmpty()) {
                int[] keyFrames = new int[keyFrameStrings.size()];
                for (int i = 0; i < keyFrameStrings.size(); ++i) {
                    int keyFrame;
                    keyFrames[i] = keyFrame = Integer.parseInt(keyFrameStrings.get(i));
                }
                customKeyFrameDurations.put(sprite.getName().toLowerCase(), keyFrames);
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private Point getLocation(int index) {
        int row = index / this.getColumns();
        int column = index % this.getColumns();
        return new Point(column * this.getSpriteWidth(), row * this.getSpriteHeight());
    }

    private void updateRowsAndCols() {
        BufferedImage sprite = this.getImage();
        if (sprite != null && sprite.getWidth() != 0 && sprite.getHeight() != 0 && this.spriteWidth != 0 && this.spriteHeight != 0) {
            this.columns = sprite.getWidth() / this.spriteWidth;
            this.rows = sprite.getHeight() / this.spriteHeight;
        } else {
            this.columns = 0;
            this.rows = 0;
        }
        if (this.columns == 0 || this.rows == 0) {
            String error = "The spritesheet " + this.getName() + " doesn't provide the correct dimensions: Sprite(" + this.spriteWidth + "/" + this.spriteHeight + ")";
            if (sprite != null) {
                error = error + ", Spritesheet(" + sprite.getWidth() + "/" + sprite.getHeight() + ")";
            }
            throw new IllegalArgumentException(error);
        }
    }
}

