/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.gui.GuiProperties;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SpeechBubble
implements IUpdateable,
IRenderable {
    private static final Map<IEntity, SpeechBubble> activeSpeechBubbles = new ConcurrentHashMap<IEntity, SpeechBubble>();
    private static final int DISPLAYTIME_MIN = 2000;
    private static final int DISPLAYTIME_PER_LETTER = 120;
    private static final int LETTER_WRITE_DELAY = 30;
    private static final int PADDING = 4;
    private static final int TRIANGLE_SIZE = 6;
    private static final Color SPEAK_BACKGROUNDCOLOR = new Color(0, 0, 0, 80);
    private static final Color SPEAK_BORDERCOLOR = new Color(0, 0, 0, 160);
    private static final Color SPEAK_FONT_COLOR = Color.WHITE;
    private Image bubble;
    private boolean cancelled;
    private String currentText;
    private final int currentTextDisplayTime;
    private final Queue<Character> currentTextQueue;
    private String displayedText;
    private final IEntity entity;
    private final Font font;
    private int height;
    private long lastCharPoll;
    private long lastTextDispay;
    private int textBoxWidth;
    private Sound typeSound;

    public static SpeechBubble createEntityBubble(IEntity entity, String text) {
        float fontSize = (float)GuiProperties.getDefaultAppearance().getFont().getSize() / Game.getCamera().getRenderScale();
        return new SpeechBubble(entity, GuiProperties.getDefaultAppearance().getFont().deriveFont(fontSize), text);
    }

    public static SpeechBubble createEntityBubble(IEntity entity, Font font, String text) {
        return new SpeechBubble(entity, font, text);
    }

    public static SpeechBubble createEntityBubble(IEntity entity, Font font, String text, Sound typeSound) {
        return new SpeechBubble(entity, font, text, typeSound);
    }

    private SpeechBubble(IEntity entity, Font font, String text) {
        SpeechBubble active = activeSpeechBubbles.get(entity);
        if (active != null) {
            active.cancel();
        }
        this.textBoxWidth = (int)(entity.getWidth() * 4.0f);
        this.entity = entity;
        this.font = font;
        this.currentText = text;
        this.currentTextDisplayTime = 2000 + text.length() * 120;
        this.currentTextQueue = new ConcurrentLinkedQueue<Character>();
        this.displayedText = "";
        for (int i = 0; i < this.currentText.length(); ++i) {
            this.currentTextQueue.add(Character.valueOf(this.currentText.charAt(i)));
        }
        this.lastTextDispay = Game.getLoop().getTicks();
        this.createBubbleImage();
        Game.getEnvironment().add(this, RenderType.OVERLAY);
        Game.getLoop().attach(this);
        activeSpeechBubbles.put(entity, this);
    }

    private SpeechBubble(IEntity entity, Font font, String text, Sound typeSound) {
        this(entity, font, text);
        this.typeSound = typeSound;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.displayedText == null || this.displayedText.isEmpty() || !Game.getRenderEngine().canRender(this.entity)) {
            return;
        }
        Point2D location = Game.getCamera().getViewPortLocation(this.entity);
        RenderEngine.renderImage(g, this.bubble, new Point2D.Double(location.getX() + (double)this.entity.getWidth() / 2.0 - (double)this.textBoxWidth / 2.0 - 4.0, location.getY() - (double)this.height - 4.0));
        g.setColor(SPEAK_FONT_COLOR);
        FontRenderContext frc = g.getFontRenderContext();
        String text = this.displayedText;
        AttributedString styledText = new AttributedString(text);
        styledText.addAttribute(TextAttribute.FONT, this.font);
        AttributedCharacterIterator iterator = styledText.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(iterator, frc);
        measurer.setPosition(0);
        float x = (float)Game.getCamera().getViewPortLocation(this.entity).getX() + this.entity.getWidth() / 2.0f - (float)this.textBoxWidth / 2.0f;
        float y = (float)Game.getCamera().getViewPortLocation(this.entity).getY() - (float)this.height;
        while (measurer.getPosition() < text.length()) {
            TextLayout layout = measurer.nextLayout(this.textBoxWidth);
            float dx = layout.isLeftToRight() ? 0.0f : (float)this.textBoxWidth - layout.getAdvance();
            layout.draw(g, x + dx, y += layout.getAscent());
            y += layout.getDescent() + layout.getLeading();
        }
    }

    @Override
    public void update() {
        if (this.currentText == null || this.cancelled) {
            Game.getEnvironment().removeRenderable(this);
            Game.getLoop().detach(this);
            return;
        }
        if (this.lastTextDispay != 0L && Game.getLoop().getDeltaTime(this.lastTextDispay) > (long)this.currentTextDisplayTime) {
            this.currentText = null;
            this.displayedText = null;
            this.lastTextDispay = 0L;
            return;
        }
        if (!this.currentTextQueue.isEmpty() && Game.getLoop().getDeltaTime(this.lastCharPoll) > 30L) {
            this.displayedText = this.displayedText + this.currentTextQueue.poll();
            this.lastCharPoll = Game.getLoop().getTicks();
            if (this.typeSound != null) {
                Game.getSoundEngine().playSound(this.entity, this.typeSound);
            }
        }
    }

    private void cancel() {
        this.cancelled = true;
    }

    private void createBubbleImage() {
        BufferedImage img = ImageProcessing.getCompatibleImage(500, 500);
        Graphics2D g = img.createGraphics();
        g.setFont(this.font);
        int stringWidth = g.getFontMetrics().stringWidth(this.currentText);
        if (stringWidth < this.textBoxWidth) {
            this.textBoxWidth = stringWidth;
        }
        FontRenderContext frc = g.getFontRenderContext();
        AttributedString styledText = new AttributedString(this.currentText);
        styledText.addAttribute(TextAttribute.FONT, this.font);
        AttributedCharacterIterator iterator = styledText.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(iterator, frc);
        measurer.setPosition(0);
        float y = 0.0f;
        while (measurer.getPosition() < this.currentText.length()) {
            TextLayout layout = measurer.nextLayout(this.textBoxWidth);
            y = (float)((double)y + ((double)(layout.getAscent() + layout.getLeading()) + 0.2));
        }
        RoundRectangle2D.Double bounds = new RoundRectangle2D.Double(0.0, 0.0, this.textBoxWidth + 8, y + 8.0f, 4.0, 4.0);
        GeneralPath path = new GeneralPath();
        path.moveTo(((RectangularShape)bounds).getWidth() / 2.0 - 3.0, ((RectangularShape)bounds).getHeight());
        path.lineTo(((RectangularShape)bounds).getWidth() / 2.0, ((RectangularShape)bounds).getHeight() + 6.0);
        path.lineTo(((RectangularShape)bounds).getWidth() / 2.0 + 3.0, ((RectangularShape)bounds).getHeight());
        path.closePath();
        Area ar = new Area(bounds);
        ar.add(new Area(path));
        int width = ar.getBounds().width;
        this.height = ar.getBounds().height;
        g.setColor(SPEAK_BACKGROUNDCOLOR);
        g.fill(ar);
        g.setColor(SPEAK_BORDERCOLOR);
        g.draw(ar);
        g.dispose();
        this.bubble = ImageProcessing.crop(img, 1, 1, width + 1, this.height + 1);
    }
}

