/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.graphics.ImageEffect;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class RotationImageEffect
extends ImageEffect {
    private final float angle;

    public RotationImageEffect(int ttl, float angle) {
        super(ttl, "RotationImageEffect");
        this.angle = angle;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        if (image == null) {
            return null;
        }
        int size = Math.max(image.getWidth(), image.getHeight()) * 2;
        BufferedImage img = ImageProcessing.getCompatibleImage(size, size);
        Graphics2D g = img.createGraphics();
        RenderEngine.renderImage(g, (Image)image, new Point2D.Double(0.0, 0.0), (double)this.getAngle());
        g.dispose();
        return img;
    }

    public float getAngle() {
        return this.angle;
    }
}

