/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.EntityYComparator;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapRenderer;
import de.gurkenlabs.litiengine.environment.tilemap.MapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.OrthogonalMapRenderer;
import de.gurkenlabs.litiengine.graphics.IRenderEngine;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderEvent;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.animation.IAnimationController;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class RenderEngine
implements IRenderEngine {
    private final EntityYComparator entityComparator;
    private final List<Consumer<RenderEvent<IEntity>>> entityRenderedConsumer = new CopyOnWriteArrayList<Consumer<RenderEvent<IEntity>>>();
    private final List<Predicate<IEntity>> entityRenderingConditions;
    private final List<Consumer<RenderEvent<IEntity>>> entityRenderingConsumer = new CopyOnWriteArrayList<Consumer<RenderEvent<IEntity>>>();
    private final List<Consumer<RenderEvent<IMap>>> mapRenderedConsumer;
    private final EnumMap<MapOrientation, IMapRenderer> mapRenderer;

    public RenderEngine() {
        this.entityRenderingConditions = new CopyOnWriteArrayList<Predicate<IEntity>>();
        this.mapRenderedConsumer = new CopyOnWriteArrayList<Consumer<RenderEvent<IMap>>>();
        this.mapRenderer = new EnumMap(MapOrientation.class);
        this.entityComparator = new EntityYComparator();
        this.mapRenderer.put(MapOrientation.ORTHOGONAL, new OrthogonalMapRenderer());
    }

    @Override
    public void renderText(Graphics2D g, String text, double x, double y) {
        if (text == null || text.isEmpty()) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        Point2D viewPortLocation = Game.getCamera().getViewPortLocation(x, y);
        g.drawString(text, (float)viewPortLocation.getX() * Game.getCamera().getRenderScale(), (float)viewPortLocation.getY() * Game.getCamera().getRenderScale());
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    @Override
    public void renderText(Graphics2D g, String text, Point2D location) {
        this.renderText(g, text, location.getX(), location.getY());
    }

    public static void drawRotatedText(Graphics2D g, double x, double y, int angle, String text) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.rotate(Math.toRadians(angle), x, y);
        RenderEngine.drawText(g2, text, x, y);
        g2.dispose();
    }

    @Override
    public void renderShape(Graphics2D g, Shape shape) {
        if (shape == null) {
            return;
        }
        AffineTransform oldTransForm = g.getTransform();
        AffineTransform t = new AffineTransform();
        t.scale(Game.getCamera().getRenderScale(), Game.getCamera().getRenderScale());
        t.translate(Game.getCamera().getPixelOffsetX(), Game.getCamera().getPixelOffsetY());
        g.setTransform(t);
        g.fill(shape);
        g.setTransform(oldTransForm);
    }

    @Override
    public void renderOutline(Graphics2D g, Shape shape) {
        this.renderOutline(g, shape, new BasicStroke(1.0f / Game.getCamera().getRenderScale()));
    }

    @Override
    public void renderOutline(Graphics2D g, Shape shape, Stroke stroke) {
        if (shape == null) {
            return;
        }
        AffineTransform oldTransForm = g.getTransform();
        Stroke oldStroke = g.getStroke();
        AffineTransform t = new AffineTransform();
        t.scale(Game.getCamera().getRenderScale(), Game.getCamera().getRenderScale());
        t.translate(Game.getCamera().getPixelOffsetX(), Game.getCamera().getPixelOffsetY());
        g.setTransform(t);
        g.setStroke(stroke);
        g.draw(shape);
        g.setTransform(oldTransForm);
        g.setStroke(oldStroke);
    }

    public static void drawText(Graphics2D g, String text, double x, double y) {
        if (text == null || text.isEmpty()) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g.drawString(text, (float)x, (float)y);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static void drawTextWithShadow(Graphics2D g, String text, double x, double y, Color shadow) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Color old = g.getColor();
        g.setColor(shadow);
        g.drawString(text, (float)x + 1.0f, (float)y + 1.0f);
        g.drawString(text, (float)x + 1.0f, (float)y - 1.0f);
        g.drawString(text, (float)x - 1.0f, (float)y - 1.0f);
        g.drawString(text, (float)x - 1.0f, (float)y + 1.0f);
        g.setColor(old);
        g.drawString(text, (float)x, (float)y);
    }

    public static void renderImage(Graphics2D g, Image image, double x, double y) {
        if (image == null) {
            return;
        }
        AffineTransform t = AffineTransform.getTranslateInstance(x, y);
        g.drawImage(image, t, null);
    }

    public static void renderImage(Graphics2D g, Image image, double x, double y, double angle) {
        if (image == null) {
            return;
        }
        if (angle == 0.0 || angle % 360.0 == 0.0) {
            RenderEngine.renderImage(g, image, x, y);
            return;
        }
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        t.rotate(Math.toRadians(angle), (double)image.getWidth(null) * 0.5, (double)image.getHeight(null) * 0.5);
        g.drawImage(image, t, null);
    }

    public static void renderImage(Graphics2D g, Image image, Point2D renderLocation) {
        RenderEngine.renderImage(g, image, renderLocation.getX(), renderLocation.getY());
    }

    public static void renderImage(Graphics2D g, Image image, Point2D renderLocation, double angle) {
        RenderEngine.renderImage(g, image, renderLocation.getX(), renderLocation.getY(), angle);
    }

    @Override
    public boolean canRender(IEntity entity) {
        if (!this.entityRenderingConditions.isEmpty()) {
            for (Predicate<IEntity> consumer : this.entityRenderingConditions) {
                if (consumer.test(entity)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void entityRenderingCondition(Predicate<IEntity> predicate) {
        if (!this.entityRenderingConditions.contains(predicate)) {
            this.entityRenderingConditions.add(predicate);
        }
    }

    @Override
    public IMapRenderer getMapRenderer(MapOrientation mapOrientation) {
        if (!this.mapRenderer.containsKey((Object)mapOrientation)) {
            throw new IllegalArgumentException("The map orientation " + (Object)((Object)mapOrientation) + " is not supported!");
        }
        return this.mapRenderer.get((Object)mapOrientation);
    }

    @Override
    public void onEntityRendered(Consumer<RenderEvent<IEntity>> entity) {
        if (!this.entityRenderedConsumer.contains(entity)) {
            this.entityRenderedConsumer.add(entity);
        }
    }

    @Override
    public void onEntityRendering(Consumer<RenderEvent<IEntity>> entity) {
        if (!this.entityRenderingConsumer.contains(entity)) {
            this.entityRenderingConsumer.add(entity);
        }
    }

    @Override
    public void onMapRendered(Consumer<RenderEvent<IMap>> map) {
        if (!this.mapRenderedConsumer.contains(map)) {
            this.mapRenderedConsumer.add(map);
        }
    }

    @Override
    public void render(Graphics2D g, Collection<? extends IRenderable> renderables) {
        renderables.forEach(r -> this.render(g, (IRenderable)r));
    }

    @Override
    public void render(Graphics2D g, Collection<? extends IRenderable> renderables, Shape clip) {
        Shape oldClip = g.getClip();
        g.setClip(clip);
        renderables.forEach(r -> r.render(g));
        g.setClip(oldClip);
    }

    @Override
    public void render(Graphics2D g, IRenderable renderable) {
        if (renderable == null) {
            return;
        }
        renderable.render(g);
    }

    @Override
    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities) {
        this.renderEntities(g, entities, true);
    }

    @Override
    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities, boolean sort) {
        List entitiesToRender = entities.stream().filter(x -> Game.getCamera().getViewPort().intersects(x.getBoundingBox())).collect(Collectors.toList());
        if (sort) {
            try {
                Collections.sort(entitiesToRender, this.entityComparator);
            }
            catch (IllegalArgumentException e) {
                for (IEntity iEntity : entities) {
                    this.renderEntity(g, iEntity);
                }
                return;
            }
        }
        for (IEntity entity : entitiesToRender) {
            this.renderEntity(g, entity);
        }
    }

    @Override
    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities, boolean sort, Shape clip) {
        Shape oldClip = g.getClip();
        if (clip != null) {
            g.setClip(clip);
        }
        this.renderEntities(g, entities, sort);
        g.setClip(oldClip);
    }

    @Override
    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities, Shape clip) {
        this.renderEntities(g, entities, true, clip);
    }

    @Override
    public void renderEntity(Graphics2D g, IEntity entity) {
        IAnimationController animationController;
        if (entity == null) {
            return;
        }
        if (entity.getRenderType() == RenderType.NONE || !this.canRender(entity)) {
            return;
        }
        RenderEvent<IEntity> renderEvent = new RenderEvent<IEntity>(g, entity);
        if (!this.entityRenderingConsumer.isEmpty()) {
            for (Consumer<RenderEvent<IEntity>> consumer : this.entityRenderingConsumer) {
                consumer.accept(renderEvent);
            }
        }
        if ((animationController = Game.getEntityControllerManager().getAnimationController(entity)) != null) {
            BufferedImage img = animationController.getCurrentSprite();
            if (img == null) {
                return;
            }
            float deltaX = (entity.getWidth() - (float)img.getWidth()) / 2.0f;
            float deltaY = (entity.getHeight() - (float)img.getHeight()) / 2.0f;
            RenderEngine.renderImage(g, img, Game.getCamera().getViewPortLocation(entity.getX() + (double)deltaX, entity.getY() + (double)deltaY));
        }
        if (entity instanceof IRenderable) {
            ((IRenderable)((Object)entity)).render(g);
        }
        if (!this.entityRenderedConsumer.isEmpty()) {
            for (Consumer<RenderEvent<IEntity>> consumer : this.entityRenderedConsumer) {
                consumer.accept(renderEvent);
            }
        }
    }

    @Override
    public void renderLayers(Graphics2D g, IMap map, RenderType type) {
        if (map == null) {
            return;
        }
        this.mapRenderer.get((Object)map.getOrientation()).renderOverlay(g, map, Game.getCamera().getViewPort());
    }

    @Override
    public void renderMap(Graphics2D g, IMap map) {
        if (map == null) {
            return;
        }
        this.mapRenderer.get((Object)map.getOrientation()).render(g, map, Game.getCamera().getViewPort());
        for (Consumer<RenderEvent<IMap>> consumer : this.mapRenderedConsumer) {
            consumer.accept(new RenderEvent<IMap>(g, map));
        }
    }
}

