/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.IRenderComponent;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.ImageFormat;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.io.ImageSerializer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class RenderComponent
extends Canvas
implements IRenderComponent {
    private static final int DEBUG_MOUSE_SIZE = 5;
    private final transient List<Consumer<Integer>> fpsChangedConsumer;
    private final transient List<Consumer<Graphics2D>> renderedConsumer;
    private transient BufferStrategy currentBufferStrategy;
    private float currentAlpha;
    private transient Image cursorImage;
    private int cursorOffsetX;
    private int cursorOffsetY;
    private long fadeInStart;
    private int fadeInTime;
    private long fadeOutStart;
    private int fadeOutTime;
    private int frameCount = 0;
    private long lastFpsTime = System.currentTimeMillis();
    private boolean takeScreenShot;

    public RenderComponent(Dimension size) {
        this.renderedConsumer = new CopyOnWriteArrayList<Consumer<Graphics2D>>();
        this.fpsChangedConsumer = new CopyOnWriteArrayList<Consumer<Integer>>();
        BufferedImage cursorImg = ImageProcessing.getCompatibleImage(16, 16);
        Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "blank cursor");
        this.setCursor(blankCursor);
        this.setSize(size);
        this.setPreferredSize(size);
    }

    @Override
    public void fadeIn(int ms) {
        this.fadeOutStart = -1L;
        this.fadeOutTime = -1;
        this.fadeInStart = Game.getLoop().getTicks();
        this.fadeInTime = ms;
    }

    @Override
    public void fadeOut(int ms) {
        this.fadeInStart = -1L;
        this.fadeInTime = -1;
        this.fadeOutStart = Game.getLoop().getTicks();
        this.fadeOutTime = ms;
    }

    @Override
    public Image getCursorImage() {
        return this.cursorImage;
    }

    public int getCursorOffsetX() {
        return this.cursorOffsetX;
    }

    public int getCursorOffsetY() {
        return this.cursorOffsetY;
    }

    @Override
    public void init() {
        this.createBufferStrategy(2);
        this.currentBufferStrategy = this.getBufferStrategy();
        this.currentAlpha = 1.1f;
    }

    @Override
    public void onFpsChanged(Consumer<Integer> fpsConsumer) {
        if (this.fpsChangedConsumer.contains(fpsConsumer)) {
            return;
        }
        this.fpsChangedConsumer.add(fpsConsumer);
    }

    @Override
    public void onRendered(Consumer<Graphics2D> renderedConsumer) {
        if (!this.renderedConsumer.contains(renderedConsumer)) {
            this.renderedConsumer.add(renderedConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(IRenderable screen) {
        long currentMillis = System.currentTimeMillis();
        this.handleFade();
        Graphics2D g = null;
        try {
            g = (Graphics2D)this.currentBufferStrategy.getDrawGraphics();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setClip(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            screen.render(g);
            Rectangle rect = new Rectangle(this.getLocationOnScreen().x, this.getLocationOnScreen().y, this.getWidth(), this.getHeight());
            if (this.cursorImage != null && (Input.mouse().isGrabMouse() || MouseInfo.getPointerInfo() != null && rect.contains(MouseInfo.getPointerInfo().getLocation()))) {
                Point2D.Double locationWithOffset = new Point2D.Double(Input.mouse().getLocation().getX() - (double)this.getCursorOffsetX(), Input.mouse().getLocation().getY() - (double)this.getCursorOffsetY());
                RenderEngine.renderImage(g, this.cursorImage, locationWithOffset);
            }
            if (Game.getConfiguration().debug().isRenderDebugMouse()) {
                g.setColor(Color.RED);
                g.draw(new Line2D.Double(Input.mouse().getLocation().getX(), Input.mouse().getLocation().getY() - 5.0, Input.mouse().getLocation().getX(), Input.mouse().getLocation().getY() + 5.0));
                g.draw(new Line2D.Double(Input.mouse().getLocation().getX() - 5.0, Input.mouse().getLocation().getY(), Input.mouse().getLocation().getX() + 5.0, Input.mouse().getLocation().getY()));
            }
            for (Consumer<Graphics2D> consumer2 : this.renderedConsumer) {
                consumer2.accept(g);
            }
            if (this.currentAlpha != -1.0f) {
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f - this.currentAlpha));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.takeScreenShot) {
                BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                Graphics2D imgGraphics = img.createGraphics();
                screen.render(imgGraphics);
                imgGraphics.dispose();
                this.saveScreenShot(img);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        this.currentBufferStrategy.show();
        Toolkit.getDefaultToolkit().sync();
        ++this.frameCount;
        if (currentMillis - this.lastFpsTime >= 1000L) {
            this.lastFpsTime = currentMillis;
            this.fpsChangedConsumer.forEach(consumer -> consumer.accept(this.frameCount));
            this.frameCount = 0;
        }
    }

    @Override
    public void setCursor(Image image) {
        this.cursorImage = image;
        if (this.cursorImage != null) {
            this.setCursorOffsetX(-(this.cursorImage.getWidth(null) / 2));
            this.setCursorOffsetY(-(this.cursorImage.getHeight(null) / 2));
        } else {
            this.setCursorOffsetX(0);
            this.setCursorOffsetY(0);
        }
    }

    @Override
    public void setCursor(Image image, int offsetX, int offsetY) {
        this.setCursor(image);
        this.setCursorOffset(offsetX, offsetY);
    }

    @Override
    public void setCursorOffset(int x, int y) {
        this.setCursorOffsetX(x);
        this.setCursorOffsetY(y);
    }

    @Override
    public void setCursorOffsetX(int cursorOffsetX) {
        this.cursorOffsetX = cursorOffsetX;
    }

    @Override
    public void setCursorOffsetY(int cursorOffsetY) {
        this.cursorOffsetY = cursorOffsetY;
    }

    @Override
    public void takeScreenshot() {
        this.takeScreenShot = true;
    }

    private void handleFade() {
        if (this.fadeOutStart != -1L) {
            long timePassed = Game.getLoop().getDeltaTime(this.fadeOutStart);
            this.currentAlpha = MathUtilities.clamp(1.0f - (float)timePassed / (float)this.fadeOutTime, 0.0f, 1.0f);
            if (this.currentAlpha == 0.0f) {
                this.fadeOutStart = -1L;
                this.fadeOutTime = -1;
            }
            return;
        }
        if (this.fadeInStart != -1L) {
            long timePassed = Game.getLoop().getDeltaTime(this.fadeInStart);
            this.currentAlpha = MathUtilities.clamp((float)timePassed / (float)this.fadeInTime, 0.0f, 1.0f);
            if (this.currentAlpha == 1.0f) {
                this.fadeInStart = -1L;
                this.fadeInTime = -1;
                this.currentAlpha = -1.0f;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScreenShot(BufferedImage img) {
        try {
            String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
            File folder = new File("./screenshots/");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ImageSerializer.saveImage(new File("./screenshots/" + timeStamp + ImageFormat.PNG.toExtension()).toString(), img);
        }
        finally {
            this.takeScreenShot = false;
        }
    }
}

