/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.EntityInfo;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;

@EntityInfo(renderType=RenderType.GROUND)
public class LightSource
extends Entity
implements IRenderable {
    public static final String ELLIPSE = "ellipse";
    public static final String RECTANGLE = "rectangle";
    public static final String TOGGLE_MESSAGE = "toggle";
    public static final int DEFAULT_INTENSITY = 100;
    private static final float OBSTRUCTED_VISION_RADIUS = 200.0f;
    private static final float SHADOW_GRADIENT_SIZE = 100.0f;
    private static final float[] SHADOW_GRADIENT_FRACTIONS = new float[]{0.0f, 1.0f};
    private static final Color[] SHADOW_GRADIENT_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
    private boolean activated;
    private Color color;
    private int intensity;
    private Shape lightShape;
    private String lightShapeType;
    private int radius;

    public LightSource(int intensity, Color lightColor, String shapeType, boolean activated) {
        this.color = lightColor;
        this.intensity = intensity;
        this.lightShapeType = shapeType;
        this.activated = activated;
    }

    public void activate() {
        this.activated = true;
    }

    public void deactivate() {
        this.activated = false;
    }

    public Color getColor() {
        return this.color;
    }

    public int getIntensity() {
        return this.activated ? this.intensity : 0;
    }

    public Shape getLightShape() {
        return this.lightShape;
    }

    public String getLightShapeType() {
        return this.lightShapeType;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean isActive() {
        return this.activated;
    }

    @Override
    public void render(Graphics2D g) {
        if (Game.getConfiguration().graphics().renderDynamicShadows()) {
            this.renderShadows(g);
        }
    }

    public void setColor(Color result) {
        this.color = result;
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
    }

    public void setLightShapeType(String shapeType) {
        this.lightShapeType = shapeType;
    }

    @Override
    public void setLocation(Point2D location) {
        super.setLocation(location);
        switch (this.getLightShapeType()) {
            case "ellipse": {
                this.lightShape = new Ellipse2D.Double(location.getX(), location.getY(), this.getWidth(), this.getHeight());
                break;
            }
            case "rectangle": {
                this.lightShape = new Rectangle2D.Double(location.getX(), location.getY(), this.getWidth(), this.getHeight());
                break;
            }
            default: {
                this.lightShape = new Ellipse2D.Double(location.getX(), location.getY(), this.getWidth(), this.getHeight());
            }
        }
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        double shorterDimension = width;
        if (width > height) {
            shorterDimension = height;
        }
        this.setRadius((int)shorterDimension / 2);
    }

    public void toggle() {
        this.activated = !this.activated;
    }

    @Override
    public String sendMessage(Object sender, String message) {
        if (message == null || message.isEmpty()) {
            return null;
        }
        if (message.equals(TOGGLE_MESSAGE)) {
            this.toggle();
            return Boolean.toString(this.activated);
        }
        return null;
    }

    private static Ellipse2D getShadowEllipse(IEntity mob) {
        int shadowHeight = (int)(mob.getHeight() / 4.0f);
        int shadowWidth = (int)(mob.getWidth() / 3.0f);
        int yOffset = (int)mob.getHeight();
        double x = mob.getLocation().getX() + (double)((mob.getWidth() - (float)shadowWidth) / 2.0f);
        double y = mob.getLocation().getY() + (double)yOffset - (double)shadowHeight / 2.0;
        return new Ellipse2D.Double(x, y, shadowWidth, shadowHeight);
    }

    private static Predicate<? super IEntity> isInRange(Point2D center, float radius) {
        return mob -> new Ellipse2D.Double(center.getX() - (double)radius, center.getY() - (double)radius, radius * 2.0f, radius * 2.0f).contains(mob.getDimensionCenter());
    }

    private Area getObstructedVisionArea(IEntity mob, Point2D center) {
        Polygon shadowPolygon = new Polygon();
        Ellipse2D shadowEllipse = LightSource.getShadowEllipse(mob);
        Rectangle2D bounds = shadowEllipse.getBounds2D();
        float r = (float)bounds.getWidth() / 2.0f;
        float ry = (float)bounds.getHeight() / 2.0f;
        Point2D relativeCenter = Game.getCamera().getViewPortLocation(new Point((int)(bounds.getX() + (double)r), (int)(bounds.getY() + (double)ry)));
        double cx = relativeCenter.getX();
        double cy = relativeCenter.getY();
        double dx = cx - center.getX();
        double dy = cy - center.getY();
        double distSq = dx * dx + dy * dy;
        float len = (float)Math.sqrt(distSq);
        double nx = dx;
        double ny = dy;
        if (len != 0.0f) {
            nx /= (double)len;
            ny /= (double)len;
        }
        double px = -ny;
        double py = nx;
        Point2D.Double pointA = new Point2D.Double(cx - px * (double)r, cy - py * (double)ry);
        Point2D.Double pointB = new Point2D.Double(cx + px * (double)r, cy + py * (double)ry);
        Point2D pointC = GeometricUtilities.project(center, pointA, 200.0);
        Point2D pointD = GeometricUtilities.project(center, pointB, 200.0);
        shadowPolygon.reset();
        shadowPolygon.addPoint((int)pointA.getX(), (int)pointA.getY());
        shadowPolygon.addPoint((int)pointB.getX(), (int)pointB.getY());
        shadowPolygon.addPoint((int)pointD.getX(), (int)pointD.getY());
        shadowPolygon.addPoint((int)pointC.getX(), (int)pointC.getY());
        Point2D shadowRenderLocation = Game.getCamera().getViewPortLocation(new Point2D.Double(shadowEllipse.getX(), shadowEllipse.getY()));
        Ellipse2D.Double relativeEllipse = new Ellipse2D.Double(shadowRenderLocation.getX(), shadowRenderLocation.getY(), shadowEllipse.getWidth(), shadowEllipse.getHeight());
        Area ellipseArea = new Area(relativeEllipse);
        Area shadowArea = new Area(shadowPolygon);
        shadowArea.add(ellipseArea);
        return shadowArea;
    }

    private void renderShadows(Graphics2D g) {
        if (!Game.getEnvironment().getCombatEntities().stream().anyMatch(LightSource.isInRange(this.getDimensionCenter(), 100.0f))) {
            return;
        }
        RadialGradientPaint gradientPaint = new RadialGradientPaint(Game.getCamera().getViewPortDimensionCenter(this), 100.0f, SHADOW_GRADIENT_FRACTIONS, SHADOW_GRADIENT_COLORS);
        Paint oldPaint = g.getPaint();
        g.setPaint(gradientPaint);
        for (ICombatEntity mob : Game.getEnvironment().getCombatEntities()) {
            if (mob.isDead() || !LightSource.isInRange(this.getDimensionCenter(), 100.0f).test(mob)) continue;
            Area obstructedVision = this.getObstructedVisionArea(mob, Game.getCamera().getViewPortDimensionCenter(this));
            g.fill(obstructedVision);
        }
        g.setPaint(oldPaint);
    }

    private void setRadius(int radius) {
        this.radius = radius;
    }
}

