/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.IImageEffect;

public abstract class ImageEffect
implements IImageEffect {
    private final long aliveTick;
    private final String name;
    private final int ttl;
    private int priority;

    protected ImageEffect(String name) {
        this(0, name);
    }

    protected ImageEffect(int ttl, String name) {
        this.ttl = ttl;
        this.name = name;
        this.aliveTick = Game.getLoop().getTicks();
    }

    @Override
    public long getAliveTime() {
        return Game.getLoop().getDeltaTime(this.aliveTick);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getTimeToLive() {
        return this.ttl;
    }

    @Override
    public boolean timeToLiveReached() {
        return this.getTimeToLive() > 0 && this.getAliveTime() > (long)this.getTimeToLive();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(IImageEffect other) {
        return Integer.compare(this.getPriority(), other.getPriority());
    }
}

