/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public final class ImageCache {
    public static final String CACHE_DIRECTORY = "cache/";
    public static final String CACHE_DUMP_NAME = "imagecache.dump";
    public static final ImageCache IMAGES = new ImageCache();
    public static final String IMAGES_DIRECTORY = "images";
    public static final String MAP_DIRECTORY = "map";
    public static final ImageCache MAPS = new ImageCache();
    public static final ImageCache SPRITES = new ImageCache();
    public static final String SPRITES_DIRECTORY = "sprites";
    private final ConcurrentHashMap<String, BufferedImage> cache = new ConcurrentHashMap();
    private final List<Consumer<ImageCache>> clearConsumers = new CopyOnWriteArrayList<Consumer<ImageCache>>();

    private ImageCache() {
    }

    public static void clearAll() {
        IMAGES.clear();
        SPRITES.clear();
        MAPS.clear();
    }

    public void clear() {
        this.cache.clear();
    }

    public void onCleared(Consumer<ImageCache> cons) {
        this.clearConsumers.add(cons);
    }

    public void clear(String regex) {
        ArrayList<String> remove = new ArrayList<String>();
        for (String string : this.cache.keySet()) {
            if (!string.matches(regex)) continue;
            remove.add(string);
        }
        for (String string : remove) {
            this.cache.remove(string);
        }
        for (Consumer consumer : this.clearConsumers) {
            consumer.accept(this);
        }
    }

    public boolean containsKey(String key) {
        return this.cache.containsKey(key);
    }

    public BufferedImage get(String key) {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        return null;
    }

    public BufferedImage put(String key, BufferedImage value) {
        return this.cache.put(key, value);
    }

    public BufferedImage putPersistent(String key, BufferedImage value) {
        if (key == null || key.isEmpty() || value == null) {
            return null;
        }
        this.cache.put(key, value);
        return value;
    }

    public int size() {
        return this.cache.size();
    }
}

