/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.graphics.ImageEffect;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;

public class CreatureShadowImageEffect
extends ImageEffect {
    private static final Color DEFAULT_SHADOW_COLOR = new Color(124, 164, 174, 120);
    private final Creature creature;
    private final Color shadowColor;

    public CreatureShadowImageEffect(Creature creature) {
        this(creature, DEFAULT_SHADOW_COLOR);
    }

    public CreatureShadowImageEffect(Creature creature, Color shadowColor) {
        super(0, "shadow");
        this.creature = creature;
        this.shadowColor = shadowColor;
    }

    public Creature getCreature() {
        return this.creature;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        if (this.getCreature().isDead()) {
            return image;
        }
        BufferedImage buffer = ImageProcessing.getCompatibleImage(image.getWidth() * 2 + 2, image.getHeight() * 2);
        Graphics2D graphics = buffer.createGraphics();
        float offsetX = (float)image.getWidth() / 2.0f;
        float offsetY = (float)image.getHeight() / 2.0f;
        this.drawShadow(graphics, image.getWidth(), image.getHeight(), offsetX, offsetY);
        RenderEngine.renderImage(graphics, (Image)image, offsetX, (double)offsetY);
        graphics.dispose();
        return buffer;
    }

    protected Ellipse2D getShadowEllipse(float spriteWidth, float spriteHeight, float offsetX, float offsetY) {
        double ellipseWidth = 0.6 * (double)spriteWidth;
        double ellipseHeight = 0.2 * (double)spriteWidth;
        double startX = ((double)spriteWidth - ellipseWidth) / 2.0;
        double startY = (double)spriteHeight - ellipseHeight;
        return new Ellipse2D.Double(startX + (double)offsetX, startY + (double)offsetY, ellipseWidth, ellipseHeight);
    }

    private void drawShadow(Graphics2D graphics, float spriteWidth, float spriteHeight, float offsetX, float offsetY) {
        graphics.setColor(this.shadowColor);
        RenderingHints hints = graphics.getRenderingHints();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.fill(this.getShadowEllipse(spriteWidth, spriteHeight, offsetX, offsetY));
        graphics.setRenderingHints(hints);
    }
}

