/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.ICamera;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.IAnimationController;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class Camera
implements ICamera {
    private final List<Consumer<Float>> zoomChangedConsumer = new CopyOnWriteArrayList<Consumer<Float>>();
    private final List<Consumer<Point2D>> focusChangedConsumer = new CopyOnWriteArrayList<Consumer<Point2D>>();
    protected Point2D focus = new Point2D.Double(0.0, 0.0);
    private long lastShake;
    private int shakeDelay;
    private int shakeDuration = 2;
    private double shakeIntensity = 1.0;
    private double shakeOffsetX;
    private double shakeOffsetY;
    private long shakeTick;
    private Rectangle2D viewPort;
    private float zoom = 1.0f;
    private float targetZoom;
    private int zoomDelay;
    private float zoomStep;
    private long zoomTick;
    private boolean clampToMap;

    @Override
    public Point2D getFocus() {
        return this.focus;
    }

    @Override
    public Point2D getMapLocation(Point2D viewPortLocation) {
        double x = viewPortLocation.getX() - this.getPixelOffsetX();
        double y = viewPortLocation.getY() - this.getPixelOffsetY();
        return new Point2D.Double(x, y);
    }

    @Override
    public double getPixelOffsetX() {
        return this.getViewPortCenterX() - (this.getFocus() != null ? this.getFocus().getX() : 0.0);
    }

    @Override
    public double getPixelOffsetY() {
        return this.getViewPortCenterY() - (this.getFocus() != null ? this.getFocus().getY() : 0.0);
    }

    @Override
    public Rectangle2D getViewPort() {
        return this.viewPort;
    }

    @Override
    public Point2D getViewPortDimensionCenter(IEntity entity) {
        Point2D viewPortLocation = this.getViewPortLocation(entity);
        IAnimationController animationController = Game.getEntityControllerManager().getAnimationController(entity);
        if (animationController == null || animationController.getCurrentAnimation() == null) {
            return new Point2D.Double(viewPortLocation.getX() + (double)entity.getWidth() * 0.5, viewPortLocation.getY() + (double)entity.getHeight() * 0.5);
        }
        Spritesheet spriteSheet = animationController.getCurrentAnimation().getSpritesheet();
        return new Point2D.Double(viewPortLocation.getX() + (double)spriteSheet.getSpriteWidth() * 0.5, viewPortLocation.getY() + (double)spriteSheet.getSpriteHeight() * 0.5);
    }

    @Override
    public Point2D getViewPortLocation(double x, double y) {
        return new Point2D.Double(x + this.getPixelOffsetX(), y + this.getPixelOffsetY());
    }

    @Override
    public Point2D getViewPortLocation(IEntity entity) {
        return this.getViewPortLocation(entity.getLocation());
    }

    @Override
    public Point2D getViewPortLocation(Point2D mapLocation) {
        return this.getViewPortLocation(mapLocation.getX(), mapLocation.getY());
    }

    @Override
    public float getZoom() {
        return this.zoom;
    }

    @Override
    public float getRenderScale() {
        return Game.getInfo().getDefaultRenderScale() * this.getZoom();
    }

    @Override
    public void onZoomChanged(Consumer<Float> zoomCons) {
        this.zoomChangedConsumer.add(zoomCons);
    }

    @Override
    public void onFocusChanged(Consumer<Point2D> focusCons) {
        this.focusChangedConsumer.add(focusCons);
    }

    @Override
    public void setFocus(Point2D focus) {
        double fraction = focus.getY() - Math.floor(focus.getY());
        if (MathUtilities.isInt(fraction * 4.0)) {
            focus.setLocation(focus.getX(), focus.getY() + 0.01);
        }
        this.focus = this.clampToMap(focus);
        for (Consumer<Point2D> consumer : this.focusChangedConsumer) {
            consumer.accept(this.focus);
        }
    }

    @Override
    public void setFocus(double x, double y) {
        this.setFocus(new Point2D.Double(x, y));
    }

    @Override
    public void setZoom(float targetZoom, int delay) {
        if (delay == 0) {
            for (Consumer<Float> cons : this.zoomChangedConsumer) {
                cons.accept(Float.valueOf(targetZoom));
            }
            this.zoom = targetZoom;
            this.targetZoom = 0.0f;
            this.zoomDelay = 0;
            this.zoomTick = 0L;
            this.zoomStep = 0.0f;
        } else {
            this.zoomTick = Game.getLoop().getTicks();
            this.targetZoom = targetZoom;
            this.zoomDelay = delay;
            double tickduration = 1000.0 / (double)Game.getLoop().getUpdateRate();
            double tickAmount = (double)delay / tickduration;
            float totalDelta = this.targetZoom - this.zoom;
            this.zoomStep = tickAmount > 0.0 ? (float)((double)totalDelta / tickAmount) : totalDelta;
        }
    }

    @Override
    public void shake(double intensity, int delay, int shakeDuration) {
        this.shakeTick = Game.getLoop().getTicks();
        this.shakeDelay = delay;
        this.shakeIntensity = intensity;
        this.shakeDuration = shakeDuration;
    }

    @Override
    public void update() {
        if (Game.getCamera() != null && !Game.getCamera().equals(this)) {
            return;
        }
        if (this.targetZoom > 0.0f) {
            if (Game.getLoop().getDeltaTime(this.zoomTick) >= (long)this.zoomDelay) {
                for (Consumer<Float> cons : this.zoomChangedConsumer) {
                    cons.accept(Float.valueOf(this.zoom));
                }
                this.zoom = this.targetZoom;
                this.targetZoom = 0.0f;
                this.zoomDelay = 0;
                this.zoomTick = 0L;
                this.zoomStep = 0.0f;
            } else {
                this.zoom += this.zoomStep;
                for (Consumer<Float> cons : this.zoomChangedConsumer) {
                    cons.accept(Float.valueOf(this.zoom));
                }
            }
        }
        if (!this.isShakeEffectActive()) {
            this.shakeOffsetX = 0.0;
            this.shakeOffsetY = 0.0;
            return;
        }
        if (Game.getLoop().getDeltaTime(this.lastShake) > (long)this.shakeDelay) {
            this.shakeOffsetX = this.getShakeIntensity() * (double)MathUtilities.randomSign();
            this.shakeOffsetY = this.getShakeIntensity() * (double)MathUtilities.randomSign();
            this.lastShake = Game.getLoop().getTicks();
        }
    }

    @Override
    public void updateFocus() {
        this.setFocus(this.applyShakeEffect(this.getFocus()));
        double viewPortY = this.getFocus().getY() - this.getViewPortCenterY();
        this.viewPort = new Rectangle2D.Double(this.getFocus().getX() - this.getViewPortCenterX(), viewPortY, Game.getScreenManager().getResolution().getWidth() / (double)this.getRenderScale(), Game.getScreenManager().getResolution().getHeight() / (double)this.getRenderScale());
    }

    @Override
    public boolean isClampToMap() {
        return this.clampToMap;
    }

    @Override
    public void setClampToMap(boolean clampToMap) {
        this.clampToMap = clampToMap;
    }

    protected Point2D clampToMap(Point2D focus) {
        if (Game.getEnvironment() == null || Game.getEnvironment().getMap() == null || !this.isClampToMap()) {
            return focus;
        }
        Dimension mapSize = Game.getEnvironment().getMap().getSizeInPixels();
        Dimension resolution = Game.getScreenManager().getResolution();
        double minX = resolution.getWidth() / (double)this.getRenderScale() / 2.0;
        double maxX = mapSize.getWidth() - minX;
        double minY = resolution.getHeight() / (double)this.getRenderScale() / 2.0;
        double maxY = mapSize.getHeight() - minY;
        double x = mapSize.getWidth() * (double)this.getRenderScale() < resolution.getWidth() ? minX : MathUtilities.clamp(focus.getX(), minX, maxX);
        double y = mapSize.getHeight() * (double)this.getRenderScale() < resolution.getHeight() ? minY : MathUtilities.clamp(focus.getY(), minY, maxY);
        return new Point2D.Double(x, y);
    }

    private Point2D applyShakeEffect(Point2D cameraLocation) {
        if (this.isShakeEffectActive()) {
            return new Point2D.Double(cameraLocation.getX() + this.shakeOffsetX, cameraLocation.getY() + this.shakeOffsetY);
        }
        return cameraLocation;
    }

    private int getShakeDuration() {
        return this.shakeDuration;
    }

    private double getShakeIntensity() {
        return this.shakeIntensity;
    }

    private long getShakeTick() {
        return this.shakeTick;
    }

    private double getViewPortCenterX() {
        return Game.getScreenManager().getResolution().getWidth() * 0.5 / (double)this.getRenderScale();
    }

    private double getViewPortCenterY() {
        return Game.getScreenManager().getResolution().getHeight() * 0.5 / (double)this.getRenderScale();
    }

    private boolean isShakeEffectActive() {
        return this.getShakeTick() != 0L && Game.getLoop().getDeltaTime(this.getShakeTick()) < (long)this.getShakeDuration();
    }
}

