/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.graphics.ColorLayer;
import de.gurkenlabs.litiengine.graphics.LightSource;
import de.gurkenlabs.litiengine.graphics.StaticShadow;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import de.gurkenlabs.litiengine.util.geom.Vector2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AmbientLight
extends ColorLayer {
    public AmbientLight(IEnvironment env, Color ambientColor, int ambientAlpha) {
        super(env, ambientColor, ambientAlpha);
        this.createImage();
    }

    @Override
    protected void renderLayer(Graphics2D g) {
        Color colorWithAlpha = this.getColorWithAlpha();
        double mapWidth = this.getEnvironment().getMap().getSizeInPixels().getWidth();
        double mapHeight = this.getEnvironment().getMap().getSizeInPixels().getHeight();
        double longerDimension = mapWidth;
        if (mapWidth < mapHeight) {
            longerDimension = mapHeight;
        }
        Area darkArea = new Area(new Rectangle2D.Double(0.0, 0.0, mapWidth, mapHeight));
        for (LightSource light : this.getEnvironment().getLightSources()) {
            if (!light.isActive()) continue;
            this.renderLightSource(g, light, longerDimension);
        }
        g.setColor(colorWithAlpha);
        g.setComposite(AlphaComposite.getInstance(7, 1.0f));
        g.fill(darkArea);
        for (LightSource light : this.getEnvironment().getLightSources()) {
            if (light.getIntensity() <= 0) continue;
            float intensity = MathUtilities.clamp((float)light.getIntensity() / 255.0f, 0.0f, 1.0f);
            g.setComposite(AlphaComposite.getInstance(3, intensity));
            this.renderLightSource(g, light, longerDimension);
        }
    }

    @Override
    protected String getCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getColor());
        sb.append(this.getAlpha());
        for (LightSource light : this.getEnvironment().getLightSources()) {
            sb.append(light.getIntensity());
            sb.append(light.getColor());
            sb.append(light.getLocation());
            sb.append(light.getRadius());
            sb.append(light.getLightShapeType());
            sb.append(light.getWidth());
            sb.append(light.getHeight());
            sb.append(light.isActive());
        }
        sb.append(this.getEnvironment().getMap().getSizeInPixels());
        int key = sb.toString().hashCode();
        return "ambientlight-" + this.getEnvironment().getMap().getFileName() + "-" + Integer.toString(key);
    }

    private void renderLightSource(Graphics2D g, LightSource light, double longerDimension) {
        Point2D lightCenter = light.getDimensionCenter();
        Area lightArea = null;
        if (light.getLightShapeType().equals("rectangle")) {
            g.setColor(light.getColor());
            g.fill(light.getBoundingBox());
            return;
        }
        for (StaticShadow col : this.getEnvironment().getStaticShadows()) {
            Line2D[] bounds;
            if (!light.getBoundingBox().intersects(col.getBoundingBox())) continue;
            if (lightArea == null) {
                lightArea = new Area(light.getLightShape());
            }
            if (!lightArea.intersects(col.getBoundingBox())) continue;
            Area boxInLight = new Area(col.getBoundingBox());
            for (Line2D line : bounds = GeometricUtilities.getLines(col.getBoundingBox())) {
                Vector2D lineVector = new Vector2D(line.getP1(), line.getP2());
                Vector2D lightVector = new Vector2D(lightCenter, line.getP1());
                if (light.getDimensionCenter().getY() < line.getY1() && light.getDimensionCenter().getY() < line.getY2() && col.getBoundingBox().contains(light.getDimensionCenter()) || lineVector.normalVector().dotProduct(lightVector) >= 0.0) continue;
                Path2D.Double shadowParallelogram = new Path2D.Double();
                Point2D shadowPoint1 = GeometricUtilities.project(lightCenter, line.getP1(), longerDimension);
                Point2D shadowPoint2 = GeometricUtilities.project(lightCenter, line.getP2(), longerDimension);
                ((Path2D)shadowParallelogram).moveTo(line.getP1().getX(), line.getP1().getY());
                ((Path2D)shadowParallelogram).lineTo(shadowPoint1.getX(), shadowPoint1.getY());
                ((Path2D)shadowParallelogram).lineTo(shadowPoint2.getX(), shadowPoint2.getY());
                ((Path2D)shadowParallelogram).lineTo(line.getP2().getX(), line.getP2().getY());
                shadowParallelogram.closePath();
                Area shadowArea = new Area(shadowParallelogram);
                if (light.getDimensionCenter().getY() < col.getBoundingBox().getMaxY() && !col.getBoundingBox().contains(light.getDimensionCenter())) {
                    shadowArea.add(boxInLight);
                }
                shadowArea.intersect(lightArea);
                lightArea.subtract(shadowArea);
            }
        }
        Paint oldPaint = g.getPaint();
        Shape lightShape = light.getLightShape();
        Color[] transColors = new Color[]{light.getColor(), new Color(light.getColor().getRed(), light.getColor().getGreen(), light.getColor().getBlue(), 0)};
        g.setPaint(new RadialGradientPaint(new Point2D.Double(lightShape.getBounds2D().getCenterX(), lightShape.getBounds2D().getCenterY()), (float)(lightShape.getBounds2D().getWidth() / 2.0), new float[]{0.0f, 1.0f}, transColors));
        g.fill(lightArea == null ? light.getBoundingBox() : lightArea);
        g.setPaint(oldPaint);
    }
}

