/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ITerrain;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Animation;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.awt.Point;
import java.io.Serializable;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="tile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Tile
extends CustomPropertyProvider
implements ITile,
Serializable {
    protected static final long FLIPPED_HORIZONTALLY_FLAG = Integer.MIN_VALUE;
    protected static final long FLIPPED_VERTICALLY_FLAG = -3221225472L;
    protected static final long FLIPPED_DIAGONALLY_FLAG = -3758096384L;
    protected static final long FLIPPED_HORIZONTALLY_FLAG_CSV = 0x80000000L;
    protected static final long FLIPPED_VERTICALLY_FLAG_CSV = 0x40000000L;
    protected static final long FLIPPED_DIAGONALLY_FLAG_CSV = 0x20000000L;
    private static final long serialVersionUID = -7597673646108642906L;
    @XmlAttribute
    private Integer gid;
    @XmlAttribute
    private Integer id;
    @XmlAttribute
    private String terrain;
    @XmlElement(required=false)
    private Animation animation;
    private transient Point tileCoordinate;
    private transient ITerrain[] terrains;
    private transient long gidMask;
    private transient boolean csv;

    public Tile() {
    }

    public Tile(int gid) {
        this.gid = gid;
    }

    public Tile(long gidBitmask, boolean csv) {
        this.csv = csv;
        long tileId = gidBitmask;
        tileId = this.csv ? (tileId &= 0xFFFFFFFF1FFFFFFFL) : (tileId &= 0x1FFFFFFFL);
        this.gidMask = gidBitmask;
        this.gid = (int)tileId;
    }

    @Override
    public boolean isFlippedHorizontally() {
        if (this.csv) {
            return (this.gidMask & 0x80000000L) == 0x80000000L;
        }
        return (this.gidMask & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    @Override
    public boolean isFlippedVertically() {
        if (this.csv) {
            return (this.gidMask & 0x40000000L) == 0x40000000L;
        }
        return (this.gidMask & 0xFFFFFFFF40000000L) == -3221225472L;
    }

    @Override
    public boolean isFlippedDiagonally() {
        if (this.csv) {
            return (this.gidMask & 0x20000000L) == 0x20000000L;
        }
        return (this.gidMask & 0xFFFFFFFF20000000L) == -3758096384L;
    }

    @Override
    public int getGridId() {
        if (this.gid == null) {
            return 0;
        }
        return this.gid;
    }

    @Override
    public Point getTileCoordinate() {
        return this.tileCoordinate;
    }

    public void setTileCoordinate(Point tileCoordinate) {
        this.tileCoordinate = tileCoordinate;
    }

    @Override
    public int getId() {
        if (this.id == null) {
            return 0;
        }
        return this.id;
    }

    @Override
    public ITerrain[] getTerrain() {
        return this.terrains;
    }

    @Override
    public ITileAnimation getAnimation() {
        return this.animation;
    }

    protected int[] getTerrainIds() {
        int[] terrainIds = new int[]{-1, -1, -1, -1};
        if (this.terrain == null || this.terrain.isEmpty()) {
            return terrainIds;
        }
        int[] ids = ArrayUtilities.getIntegerArray(this.terrain);
        if (ids.length != 4) {
            return terrainIds;
        }
        terrainIds = ids;
        return terrainIds;
    }

    protected void setTerrains(ITerrain[] terrains) {
        this.terrains = terrains;
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.gid != null && this.gid == 0) {
            this.gid = null;
        }
        if (this.id != null && this.id == 0) {
            this.id = null;
        }
    }
}

