/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.IMapImage;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="image")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MapImage
extends CustomPropertyProvider
implements IMapImage {
    private static final long serialVersionUID = -3571362172734426098L;
    @XmlAttribute
    private String source;
    @XmlAttribute(name="trans")
    private String transparentcolor;
    @XmlAttribute
    private int width;
    @XmlAttribute
    private int height;
    @XmlTransient
    private String absolutPath;

    @Override
    public String getAbsoluteSourcePath() {
        return this.absolutPath;
    }

    @Override
    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public File getSourceFile() {
        return new File(this.getSource());
    }

    @Override
    public Color getTransparentColor() {
        if (this.transparentcolor != null && !this.transparentcolor.isEmpty()) {
            return Color.decode("#" + this.transparentcolor);
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public void setAbsolutPath(String mapPath) {
        int lastBackslash = mapPath.lastIndexOf(47);
        if (lastBackslash != -1) {
            String subPath = mapPath.substring(0, lastBackslash);
            this.absolutPath = subPath + '/' + this.getSource();
        } else {
            int lastForwardSlash = mapPath.lastIndexOf(92);
            if (lastForwardSlash != -1) {
                String subPath = mapPath.substring(0, lastForwardSlash);
                this.absolutPath = subPath + '/' + this.getSource();
            }
        }
    }
}

