/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.IImageLayer;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.MapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.ImageLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tile;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="map")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Map
extends CustomPropertyProvider
implements IMap,
Serializable,
Comparable<Map> {
    public static final String FILE_EXTENSION = "tmx";
    private static final long serialVersionUID = 402776584608365440L;
    @XmlAttribute
    private double version;
    @XmlAttribute
    private String tiledversion;
    @XmlAttribute
    private String orientation;
    @XmlAttribute
    private String renderorder;
    @XmlAttribute
    private int width;
    @XmlAttribute
    private int height;
    @XmlAttribute
    private int tilewidth;
    @XmlAttribute
    private int tileheight;
    @XmlAttribute
    private int nextObjectId;
    @XmlElement(name="tileset")
    private List<Tileset> tilesets;
    @XmlElement(name="imagelayer")
    private List<ImageLayer> imagelayers;
    @XmlElement(name="layer")
    private List<TileLayer> layers;
    @XmlAttribute(required=false)
    private String name;
    @XmlElement(name="objectgroup")
    private List<MapObjectLayer> objectgroups;
    @XmlTransient
    private String path;

    @Override
    public List<IImageLayer> getImageLayers() {
        CopyOnWriteArrayList<IImageLayer> imageLayers = new CopyOnWriteArrayList<IImageLayer>();
        if (this.imagelayers != null) {
            imageLayers.addAll(this.imagelayers);
        }
        return imageLayers;
    }

    @Override
    public String getFileName() {
        return this.name;
    }

    public int getNextObjectId() {
        return this.nextObjectId;
    }

    public List<MapObjectLayer> getObjectgroups() {
        if (this.objectgroups == null) {
            this.objectgroups = new ArrayList<MapObjectLayer>();
        }
        return this.objectgroups;
    }

    @Override
    public MapOrientation getOrientation() {
        return MapOrientation.valueOf(this.orientation.toUpperCase());
    }

    @Override
    @XmlTransient
    public String getPath() {
        return this.path;
    }

    @Override
    public String getRenderorder() {
        return this.renderorder;
    }

    @Override
    public List<IMapObjectLayer> getMapObjectLayers() {
        CopyOnWriteArrayList<IMapObjectLayer> shapeLayers = new CopyOnWriteArrayList<IMapObjectLayer>();
        if (this.getObjectgroups() != null) {
            shapeLayers.addAll(this.getObjectgroups());
        }
        return shapeLayers;
    }

    @Override
    public IMapObjectLayer getMapObjectLayer(IMapObject mapObject) {
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            Optional<IMapObject> found = layer.getMapObjects().stream().filter(x -> x.getId() == mapObject.getId()).findFirst();
            if (!found.isPresent()) continue;
            return layer;
        }
        return null;
    }

    @Override
    public void removeMapObject(int mapId) {
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            IMapObject remove = null;
            for (IMapObject obj : layer.getMapObjects()) {
                if (obj.getId() != mapId) continue;
                remove = obj;
                break;
            }
            if (remove == null) continue;
            layer.removeMapObject(remove);
            break;
        }
    }

    @Override
    public Dimension getSizeInPixels() {
        return new Dimension(this.width * this.tilewidth, this.height * this.tileheight);
    }

    @Override
    public Dimension getSizeinTiles() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public List<ITileLayer> getTileLayers() {
        ArrayList<ITileLayer> lay = new ArrayList<ITileLayer>();
        if (this.layers != null) {
            lay.addAll(this.layers);
        }
        return lay;
    }

    @Override
    public List<ITileset> getTilesets() {
        ArrayList<ITileset> tileSets = new ArrayList<ITileset>();
        if (this.tilesets != null) {
            tileSets.addAll(this.tilesets);
        }
        return tileSets;
    }

    @Override
    public Dimension getTileSize() {
        return new Dimension(this.tilewidth, this.tileheight);
    }

    @Override
    public double getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setFileName(String name) {
        this.name = name;
    }

    @Override
    public Collection<IMapObject> getMapObjects(String ... types) {
        ArrayList<IMapObject> mapObjects = new ArrayList<IMapObject>();
        if (this.getMapObjectLayers() == null || this.getMapObjectLayers().isEmpty() || types.length == 0) {
            return mapObjects;
        }
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            if (layer == null) continue;
            mapObjects.addAll(layer.getMapObjects(types));
        }
        return mapObjects;
    }

    @Override
    public Collection<IMapObject> getMapObjects() {
        ArrayList<IMapObject> mapObjects = new ArrayList<IMapObject>();
        if (this.getMapObjectLayers() == null || this.getMapObjectLayers().isEmpty()) {
            return mapObjects;
        }
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            if (layer == null) continue;
            for (IMapObject mapObject : layer.getMapObjects()) {
                if (mapObject == null) continue;
                mapObjects.add(mapObject);
            }
        }
        return mapObjects;
    }

    @Override
    public IMapObject getMapObject(int mapId) {
        if (this.getMapObjectLayers() == null || this.getMapObjectLayers().isEmpty()) {
            return null;
        }
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            if (layer == null) continue;
            for (IMapObject mapObject : layer.getMapObjects()) {
                if (mapObject == null || mapObject.getId() != mapId) continue;
                return mapObject;
            }
        }
        return null;
    }

    public void setPath(String path) {
        this.path = path;
        if (this.imagelayers != null && !this.imagelayers.isEmpty()) {
            for (ImageLayer imgLayer : this.imagelayers) {
                if (imgLayer == null) continue;
                imgLayer.setMapPath(path);
            }
        }
        if (this.tilesets != null && !this.tilesets.isEmpty()) {
            for (Tileset tileSet : this.tilesets) {
                if (tileSet == null) continue;
                tileSet.setMapPath(path);
            }
        }
    }

    public void updateTileTerrain() {
        for (TileLayer layer : this.layers) {
            for (Tile tile : layer.getData()) {
                tile.setTerrains(MapUtilities.getTerrain(this, tile.getGridId()));
            }
        }
    }

    @Override
    public void addMapObjectLayer(IMapObjectLayer layer) {
        this.getObjectgroups().add((MapObjectLayer)layer);
    }

    @Override
    public void removeMapObjectLayer(IMapObjectLayer layer) {
        this.getObjectgroups().remove(layer);
    }

    @Override
    public void removeMapObjectLayer(int index) {
        this.getObjectgroups().remove(index);
    }

    @XmlTransient
    public void setHeight(int height) {
        this.height = height;
    }

    @XmlTransient
    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    @XmlTransient
    public void setRenderorder(String renderorder) {
        this.renderorder = renderorder;
    }

    @XmlTransient
    public void setTileheight(int tileheight) {
        this.tileheight = tileheight;
    }

    @XmlTransient
    public void setTilewidth(int tilewidth) {
        this.tilewidth = tilewidth;
    }

    @XmlTransient
    public void setVersion(double version) {
        this.version = version;
    }

    @XmlTransient
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int compareTo(Map o) {
        return this.name.compareTo(o.name);
    }

    public List<Tileset> getRawTileSets() {
        return this.tilesets;
    }

    public List<Tileset> getExternalTilesets() {
        ArrayList<Tileset> externalTilesets = new ArrayList<Tileset>();
        for (Tileset set : this.getRawTileSets()) {
            if (set.sourceTileset == null) continue;
            externalTilesets.add(set.sourceTileset);
        }
        return externalTilesets;
    }
}

