/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ILayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Map;
import de.gurkenlabs.litiengine.graphics.RenderType;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

public abstract class Layer
extends CustomPropertyProvider
implements ILayer,
Serializable {
    private static final long serialVersionUID = -5136089511774411328L;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private Integer width;
    @XmlAttribute
    private Integer height;
    @XmlAttribute
    private Float opacity;
    @XmlAttribute
    private Integer visible;
    @XmlAttribute
    private Integer offsetx;
    @XmlAttribute
    private Integer offsety;
    @XmlAttribute
    private int order = -1;

    public int getHeight() {
        if (this.height == null) {
            return 0;
        }
        return this.height;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getOpacity() {
        if (this.opacity == null) {
            return 1.0f;
        }
        return this.opacity.floatValue();
    }

    @Override
    public Point getPosition() {
        return new Point(this.getOffsetX(), this.getOffsetY());
    }

    @Override
    public int getOffsetX() {
        if (this.offsetx == null) {
            return 0;
        }
        return this.offsetx;
    }

    @Override
    public int getOffsetY() {
        if (this.offsety == null) {
            return 0;
        }
        return this.offsety;
    }

    @Override
    public RenderType getRenderType() {
        String renderTypeProp = this.getCustomProperty("RENDERTYPE");
        if (renderTypeProp != null && !renderTypeProp.isEmpty()) {
            return RenderType.valueOf(renderTypeProp);
        }
        return RenderType.NORMAL;
    }

    @Override
    public Dimension getSizeInTiles() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        if (this.width == null) {
            return 0;
        }
        return this.width;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean isVisible() {
        if (this.visible == null) {
            return true;
        }
        return this.visible > 0;
    }

    @Override
    @XmlTransient
    public void setName(String name) {
        this.name = name;
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.order == -1 && parent instanceof Map) {
            Map map = (Map)parent;
            int layerCnt = map.getTileLayers().size();
            layerCnt += map.getImageLayers().size();
            this.order = layerCnt += map.getTileLayers().size();
        }
        if (this.offsetx != null && this.offsetx == 0) {
            this.offsetx = null;
        }
        if (this.offsety != null && this.offsety == 0) {
            this.offsety = null;
        }
        if (this.width != null && this.width == 0) {
            this.width = null;
        }
        if (this.height != null && this.height == 0) {
            this.height = null;
        }
        if (this.opacity != null && this.opacity.floatValue() == 1.0f) {
            this.opacity = null;
        }
        if (this.visible != null && this.visible == 1) {
            this.visible = null;
        }
    }
}

