/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="blueprint")
public class Blueprint
extends MapObject {
    private static final long serialVersionUID = -7235380251249427834L;
    @XmlElementWrapper(name="items")
    @XmlElement(name="object")
    private List<MapObject> items = new ArrayList<MapObject>();
    @XmlTransient
    private boolean keepIds;

    public Blueprint() {
    }

    public Blueprint(String name, MapObject ... items) {
        this(name, false, items);
    }

    public Blueprint(String name, boolean keepIds, MapObject ... items) {
        this.keepIds = keepIds;
        this.setType(MapObjectType.AREA.toString());
        this.setName(name);
        int minX = -1;
        int minY = -1;
        int maxX = -1;
        int maxY = -1;
        for (MapObject item : items) {
            if (minX == -1 || item.getX() < minX) {
                minX = item.getX();
            }
            if (minY == -1 || item.getY() < minY) {
                minY = item.getY();
            }
            if (maxX == -1 || item.getBoundingBox().getMaxX() > (double)maxX) {
                maxX = (int)item.getBoundingBox().getMaxX();
            }
            if (maxY != -1 && !(item.getBoundingBox().getMaxY() > (double)maxY)) continue;
            maxY = (int)item.getBoundingBox().getMaxY();
        }
        this.setWidth(maxX - minX);
        this.setHeight(maxY - minY);
        for (MapObject item : items) {
            MapObject newItem = new MapObject(item);
            newItem.setX(item.getX() - minX);
            newItem.setY(item.getY() - minY);
            if (keepIds) {
                newItem.setId(item.getId());
            }
            this.items.add(newItem);
        }
    }

    @XmlTransient
    public Iterable<MapObject> getItems() {
        return this.items;
    }

    public boolean keepIds() {
        return this.keepIds;
    }

    public List<MapObject> build(int x, int y) {
        ArrayList<MapObject> builtObjects = new ArrayList<MapObject>();
        for (MapObject item : this.getItems()) {
            MapObject newObject = new MapObject(item);
            newObject.setX(newObject.getX() + x);
            newObject.setY(newObject.getY() + y);
            newObject.setId(Game.getEnvironment().getNextMapId());
            if (this.keepIds) {
                newObject.setId(item.getId());
            }
            builtObjects.add(newObject);
        }
        return builtObjects;
    }
}

