/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapLoader;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Map;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;

public final class TmxMapLoader
implements IMapLoader {
    @Override
    public IMap loadMap(String path) {
        int lastBackslash;
        Map map = XmlUtilities.readFromFile(Map.class, path);
        if (map == null) {
            return null;
        }
        String basePath = FileUtilities.getParentDirPath(path);
        for (Tileset tilesets : map.getRawTileSets()) {
            tilesets.loadFromSource(basePath);
        }
        String name = path;
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        if ((lastBackslash = name.lastIndexOf(47)) != -1) {
            name = name.substring(lastBackslash + 1, name.length());
        } else {
            int lastForwardSlash = name.lastIndexOf(92);
            if (lastForwardSlash != -1) {
                name = name.substring(lastForwardSlash + 1, name.length());
            }
        }
        map.setFileName(name);
        map.setPath(path);
        map.updateTileTerrain();
        return map;
    }
}

