/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IImageLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ILayer;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapRenderer;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimationFrame;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.MapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.ImageCache;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;

public class OrthogonalMapRenderer
implements IMapRenderer {
    @Override
    public BufferedImage getMapImage(IMap map) {
        if (ImageCache.MAPS.containsKey(OrthogonalMapRenderer.getCacheKey(map))) {
            return ImageCache.MAPS.get(OrthogonalMapRenderer.getCacheKey(map));
        }
        BufferedImage img = ImageProcessing.getCompatibleImage((int)map.getSizeInPixels().getWidth(), (int)map.getSizeInPixels().getHeight());
        Graphics2D g = img.createGraphics();
        for (ITileLayer layer : map.getTileLayers()) {
            if (layer == null || layer.getRenderType() == RenderType.OVERLAY) continue;
            RenderEngine.renderImage(g, this.getLayerImage(layer, map, true), layer.getPosition());
        }
        g.dispose();
        ImageCache.MAPS.put(OrthogonalMapRenderer.getCacheKey(map), img);
        return img;
    }

    @Override
    public MapOrientation getSupportedOrientation() {
        return MapOrientation.ORTHOGONAL;
    }

    @Override
    public void renderImage(Graphics2D g, IMap map) {
        this.renderImage(g, map, 0.0, 0.0);
    }

    @Override
    public void renderImage(Graphics2D g, IMap map, double offsetX, double offsetY) {
        BufferedImage mapImage = this.getMapImage(map);
        RenderEngine.renderImage(g, (Image)mapImage, offsetX, offsetY);
    }

    @Override
    public void render(Graphics2D g, IMap map, Rectangle2D viewport) {
        for (ILayer layer : this.getAllRenderLayers(map)) {
            if (layer == null || layer.getRenderType() == RenderType.OVERLAY) continue;
            if (layer instanceof ITileLayer) {
                this.renderTileLayerImage(g, (ITileLayer)layer, map, viewport);
            }
            if (!(layer instanceof IImageLayer)) continue;
            this.renderImageLayer(g, (IImageLayer)layer, viewport);
        }
    }

    @Override
    public void renderOverlay(Graphics2D g, IMap map, Rectangle2D viewport) {
        for (ITileLayer layer : map.getTileLayers()) {
            if (layer == null || layer.getRenderType() != RenderType.OVERLAY) continue;
            this.renderTileLayerImage(g, layer, map, viewport);
        }
    }

    private static String getCacheKey(IMap map) {
        return MessageFormat.format("map_{0}", map.getFileName());
    }

    private static Image getTileImage(IMap map, ITile tile) {
        Spritesheet sprite;
        if (tile == null) {
            return null;
        }
        ITileset tileset = MapUtilities.findTileSet(map, tile);
        if (tileset == null || tileset.getFirstGridId() > tile.getGridId()) {
            return null;
        }
        int index = tile.getGridId() - tileset.getFirstGridId();
        ITileAnimation animation = MapUtilities.getAnimation(map, index);
        if (animation != null && !animation.getFrames().isEmpty()) {
            long playedMs = Game.getTime().sinceGameStart();
            int totalDuration = animation.getTotalDuration();
            long animationsPlayed = playedMs / (long)totalDuration;
            long deltaTicks = playedMs - animationsPlayed * (long)totalDuration;
            int currentPlayTime = 0;
            for (ITileAnimationFrame frame : animation.getFrames()) {
                if (deltaTicks >= (long)(currentPlayTime += frame.getDuration())) continue;
                index = frame.getTileId();
                break;
            }
        }
        if ((sprite = Spritesheet.find(tileset.getImage().getSource())) == null && (sprite = Spritesheet.load(tileset)) == null) {
            return null;
        }
        BufferedImage tileImage = sprite.getSprite(index);
        if (tile.isFlippedDiagonally()) {
            tileImage = ImageProcessing.rotate(tileImage, Math.toRadians(90.0));
            tileImage = ImageProcessing.verticalFlip(tileImage);
        }
        if (tile.isFlippedHorizontally()) {
            tileImage = ImageProcessing.horizontalFlip(tileImage);
        }
        if (tile.isFlippedVertically()) {
            tileImage = ImageProcessing.verticalFlip(tileImage);
        }
        return tileImage;
    }

    private List<ILayer> getAllRenderLayers(IMap map) {
        ArrayList<ILayer> layers = new ArrayList<ILayer>();
        for (ITileLayer tileLayer : map.getTileLayers()) {
            layers.add(tileLayer);
        }
        for (IImageLayer imageLayer : map.getImageLayers()) {
            layers.add(imageLayer);
        }
        layers.sort(Comparator.comparing(ILayer::getOrder));
        return layers;
    }

    private synchronized BufferedImage getLayerImage(ITileLayer layer, IMap map, boolean includeAnimationTiles) {
        String cacheKey = MessageFormat.format("{0}_{1}", OrthogonalMapRenderer.getCacheKey(map), layer.getName());
        if (ImageCache.MAPS.containsKey(cacheKey)) {
            return ImageCache.MAPS.get(cacheKey);
        }
        BufferedImage bufferedImage = ImageProcessing.getCompatibleImage(layer.getSizeInTiles().width * map.getTileSize().width, layer.getSizeInTiles().height * map.getTileSize().height);
        Graphics2D imageGraphics = bufferedImage.createGraphics();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        imageGraphics.setComposite(ac);
        layer.getTiles().parallelStream().forEach(tile -> {
            int index = layer.getTiles().indexOf(tile);
            if (tile.getGridId() == 0) {
                return;
            }
            if (!includeAnimationTiles && MapUtilities.hasAnimation(map, tile)) {
                return;
            }
            Image tileTexture = OrthogonalMapRenderer.getTileImage(map, tile);
            int x = index % layer.getSizeInTiles().width * map.getTileSize().width;
            int y = index / layer.getSizeInTiles().width * map.getTileSize().height;
            RenderEngine.renderImage(imageGraphics, tileTexture, x, (double)y);
        });
        ImageCache.MAPS.put(cacheKey, bufferedImage);
        return bufferedImage;
    }

    private void renderTileLayerImage(Graphics2D g, ITileLayer layer, IMap map, Rectangle2D viewport) {
        Point startTile = MapUtilities.getTile(map, new Point2D.Double(viewport.getX(), viewport.getY()));
        Point endTile = MapUtilities.getTile(map, new Point2D.Double(viewport.getMaxX(), viewport.getMaxY()));
        double viewportOffsetX = -(viewport.getX() - (double)(startTile.x * map.getTileSize().width)) + (double)layer.getPosition().x;
        double viewportOffsetY = -(viewport.getY() - (double)(startTile.y * map.getTileSize().height)) + (double)layer.getPosition().y;
        Composite oldComp = g.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        g.setComposite(ac);
        if (Game.getConfiguration().graphics().enableCacheStaticTiles()) {
            String cacheKey = MessageFormat.format("{0}_{1}_static", OrthogonalMapRenderer.getCacheKey(map), layer.getName());
            BufferedImage staticTileImage = null;
            if (ImageCache.MAPS.containsKey(cacheKey)) {
                staticTileImage = ImageCache.MAPS.get(cacheKey);
            } else {
                staticTileImage = this.getLayerImage(layer, map, false);
                ImageCache.MAPS.put(cacheKey, staticTileImage);
            }
            double staticX = (double)layer.getPosition().x - viewport.getX();
            double staticY = (double)layer.getPosition().x - viewport.getY();
            RenderEngine.renderImage(g, (Image)staticTileImage, staticX, staticY);
        }
        int startX = MathUtilities.clamp(startTile.x, 0, layer.getSizeInTiles().width);
        int endX = MathUtilities.clamp(endTile.x, 0, layer.getSizeInTiles().width);
        int startY = MathUtilities.clamp(startTile.y, 0, layer.getSizeInTiles().height);
        int endY = MathUtilities.clamp(endTile.y, 0, layer.getSizeInTiles().height);
        double offsetX = viewportOffsetX + (double)((startX - startTile.x) * map.getTileSize().width);
        double offsetY = viewportOffsetY + (double)((startY - startTile.y) * map.getTileSize().height);
        IntStream.range(startX, endX + 1).parallel().forEach(x -> {
            for (int y = startY; y <= endY; ++y) {
                ITile tile = layer.getTile(x, y);
                if (tile == null || Game.getConfiguration().graphics().enableCacheStaticTiles() && !MapUtilities.hasAnimation(map, tile)) continue;
                Image tileTexture = OrthogonalMapRenderer.getTileImage(map, tile);
                RenderEngine.renderImage(g, tileTexture, offsetX + (double)((x - startX) * map.getTileSize().width), offsetY + (double)((y - startY) * map.getTileSize().height));
            }
        });
        g.setComposite(oldComp);
    }

    private void renderImageLayer(Graphics2D g, IImageLayer layer, Rectangle2D viewport) {
        Composite oldComp = g.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        g.setComposite(ac);
        double viewportOffsetX = -viewport.getX() + (double)layer.getPosition().x;
        double viewportOffsetY = -viewport.getY() + (double)layer.getPosition().y;
        Spritesheet sprite = Spritesheet.find(layer.getImage().getSource());
        if (sprite == null) {
            return;
        }
        RenderEngine.renderImage(g, (Image)sprite.getImage(), viewportOffsetX, viewportOffsetY);
        g.setComposite(oldComp);
    }
}

