/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITerrain;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import java.awt.Point;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MapUtilities {
    private static Map<String, ITileAnimation> animations;
    private static Map<String, Boolean> hasAnimation;
    private static Map<String, ITileset> tilesets;

    private MapUtilities() {
    }

    public static int getMaxMapId(IMap map) {
        int maxId = 0;
        if (map == null || map.getMapObjectLayers() == null) {
            return maxId;
        }
        for (IMapObjectLayer objectLayer : map.getMapObjectLayers()) {
            if (objectLayer == null || objectLayer.getMapObjects() == null) continue;
            for (IMapObject mapObject : objectLayer.getMapObjects()) {
                if (mapObject == null || mapObject.getId() <= maxId) continue;
                maxId = mapObject.getId();
            }
        }
        return maxId;
    }

    public static Point2D getCenterMapLocation() {
        if (Game.getEnvironment() == null || Game.getEnvironment().getMap() == null) {
            return new Point2D.Double();
        }
        return MapUtilities.getCenterMapLocation(Game.getEnvironment().getMap());
    }

    public static Point2D getCenterMapLocation(IMap map) {
        return new Point2D.Double((double)map.getSizeInPixels().width / 2.0, (double)map.getSizeInPixels().height / 2.0);
    }

    public static Rectangle2D getTileBoundingBox(Point2D mapLocation) {
        if (Game.getEnvironment() == null || Game.getEnvironment().getMap() == null) {
            return new Rectangle2D.Double();
        }
        return MapUtilities.getTileBoundingBox(Game.getEnvironment().getMap(), mapLocation);
    }

    public static Rectangle2D getTileBoundingBox(IMap map, Point2D mapLocation) {
        Point location = MapUtilities.getTile(map, mapLocation);
        return new Rectangle2D.Double((double)location.x * map.getTileSize().getWidth(), (double)location.y * map.getTileSize().getHeight(), map.getTileSize().getWidth(), map.getTileSize().getHeight());
    }

    public static Rectangle2D getTileBoundingBox(Point tile) {
        if (Game.getEnvironment() == null || Game.getEnvironment().getMap() == null) {
            return new Rectangle2D.Double();
        }
        return MapUtilities.getTileBoundingBox(Game.getEnvironment().getMap(), tile);
    }

    public static Rectangle2D getTileBoundingBox(IMap map, Point tile) {
        if (map == null || tile == null) {
            return null;
        }
        return new Rectangle2D.Double((double)tile.x * map.getTileSize().getWidth(), (double)tile.y * map.getTileSize().getHeight(), map.getTileSize().getWidth(), map.getTileSize().getHeight());
    }

    public static Point getTile(Point2D mapLocation) {
        if (Game.getEnvironment() == null || Game.getEnvironment().getMap() == null) {
            return new Point();
        }
        return MapUtilities.getTile(Game.getEnvironment().getMap(), mapLocation);
    }

    public static Point getTile(IMap map, Point2D mapLocation) {
        return new Point((int)(mapLocation.getX() / map.getTileSize().getWidth()), (int)(mapLocation.getY() / map.getTileSize().getHeight()));
    }

    public static Point2D getMapLocation(IMap map, Point tileLocation) {
        return new Point2D.Double((double)tileLocation.x * map.getTileSize().getWidth(), (double)tileLocation.y * map.getTileSize().getHeight());
    }

    public static List<ITile> getTilesByPixelLocation(IMap map, Point2D location) {
        ArrayList<ITile> tilesAtLocation = new ArrayList<ITile>();
        if (map.getTileLayers() == null || map.getTileLayers().isEmpty()) {
            return tilesAtLocation;
        }
        Point tileLocation = MapUtilities.getTile(map, location);
        for (ITileLayer layer : map.getTileLayers()) {
            ITile tile = layer.getTile(tileLocation.x, tileLocation.y);
            if (tile == null) continue;
            tilesAtLocation.add(tile);
        }
        return tilesAtLocation;
    }

    public static ITile getTopMostTile(Point2D location) {
        if (Game.getEnvironment() == null || Game.getEnvironment().getMap() == null) {
            return null;
        }
        return MapUtilities.getTopMostTile(Game.getEnvironment().getMap(), location);
    }

    public static ITile getTopMostTile(IMap map, Point2D location) {
        if (map.getTileLayers() == null || map.getTileLayers().isEmpty()) {
            return null;
        }
        return MapUtilities.getTopMostTile(MapUtilities.getTile(map, location));
    }

    public static ITile getTopMostTile(Point point) {
        if (Game.getEnvironment() == null || Game.getEnvironment().getMap() == null) {
            return null;
        }
        return MapUtilities.getTopMostTile(Game.getEnvironment().getMap(), point);
    }

    public static ITile getTopMostTile(IMap map, Point point) {
        Point tileLocation = point;
        ITile tile = null;
        for (ITileLayer layer : map.getTileLayers()) {
            ITile tileOfLayer = layer.getTile(tileLocation.x, tileLocation.y);
            if (tileOfLayer == null || tileOfLayer.getGridId() == 0) continue;
            tile = tileOfLayer;
        }
        return tile;
    }

    public static ITerrain[] getTerrain(IMap map, int gId) {
        for (ITileset tileset : map.getTilesets()) {
            if (!tileset.containsTile(gId)) continue;
            return tileset.getTerrain(gId);
        }
        return new ITerrain[4];
    }

    public static boolean hasAnimation(IMap map, ITile tile) {
        ITileset tileset = MapUtilities.findTileSet(map, tile);
        if (tileset == null || tileset.getFirstGridId() > tile.getGridId()) {
            return false;
        }
        int index = tile.getGridId() - tileset.getFirstGridId();
        ITileAnimation animation = MapUtilities.getAnimation(map, index);
        return animation != null && !animation.getFrames().isEmpty();
    }

    public static ITileAnimation getAnimation(IMap map, int gId) {
        String cacheKey = map.getFileName() + "[" + gId + "]";
        if (hasAnimation.containsKey(cacheKey) && !hasAnimation.get(cacheKey).booleanValue()) {
            return null;
        }
        if (animations.containsKey(cacheKey)) {
            return animations.get(cacheKey);
        }
        for (ITileset tileset : map.getTilesets()) {
            if (!tileset.containsTile(gId)) continue;
            ITileAnimation anim = tileset.getAnimation(gId);
            boolean animation = false;
            if (anim != null) {
                animations.put(cacheKey, anim);
                animation = true;
            }
            hasAnimation.put(cacheKey, animation);
            return anim;
        }
        return null;
    }

    public static ITileset findTileSet(IMap map, ITile tile) {
        if (map == null || tile == null) {
            return null;
        }
        String cacheKey = map.getFileName() + "[" + tile.getGridId() + "]";
        if (tilesets.containsKey(cacheKey)) {
            return tilesets.get(cacheKey);
        }
        ITileset match = null;
        for (ITileset tileset : map.getTilesets()) {
            if (!tileset.containsTile(tile)) continue;
            match = tileset;
            break;
        }
        if (match != null) {
            tilesets.put(cacheKey, match);
        }
        return match;
    }

    public static Path2D convertPolylineToPath(IMapObject mapObject) {
        if (mapObject == null || mapObject.getPolyline() == null || mapObject.getPolyline().getPoints().isEmpty()) {
            return null;
        }
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(mapObject.getLocation().getX(), mapObject.getLocation().getY());
        for (int i = 1; i < mapObject.getPolyline().getPoints().size(); ++i) {
            Point2D point = mapObject.getPolyline().getPoints().get(i);
            ((Path2D)path).lineTo(mapObject.getLocation().getX() + point.getX(), mapObject.getLocation().getY() + point.getY());
        }
        return path;
    }

    public static List<Point2D> convertPolylineToPointList(IMapObject mapObject) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        if (mapObject == null || mapObject.getPolyline() == null || mapObject.getPolyline().getPoints().isEmpty()) {
            return points;
        }
        for (int i = 1; i < mapObject.getPolyline().getPoints().size(); ++i) {
            Point2D point = mapObject.getPolyline().getPoints().get(i);
            points.add(new Point2D.Double(mapObject.getLocation().getX() + point.getX(), mapObject.getLocation().getY() + point.getY()));
        }
        return points;
    }

    public static IMapObject findMapObject(IMap map, int id) {
        for (IMapObjectLayer layer : map.getMapObjectLayers()) {
            for (IMapObject obj : layer.getMapObjects()) {
                if (obj.getId() != id) continue;
                return obj;
            }
        }
        return null;
    }

    static {
        tilesets = new ConcurrentHashMap<String, ITileset>();
        animations = new ConcurrentHashMap<String, ITileAnimation>();
        hasAnimation = new ConcurrentHashMap<String, Boolean>();
        tilesets = new ConcurrentHashMap<String, ITileset>();
    }
}

