/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Trigger;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectProperty;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Property;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.util.Collection;
import java.util.HashMap;

public class TriggerMapObjectLoader
extends MapObjectLoader {
    protected TriggerMapObjectLoader() {
        super(MapObjectType.TRIGGER);
    }

    @Override
    public Collection<IEntity> load(IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.TRIGGER) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + TriggerMapObjectLoader.class);
        }
        String message = mapObject.getCustomProperty("triggermessage");
        Trigger.TriggerActivation act = mapObject.getCustomProperty("triggerActivation") != null ? Trigger.TriggerActivation.valueOf(mapObject.getCustomProperty("triggerActivation")) : Trigger.TriggerActivation.COLLISION;
        String targets = mapObject.getCustomProperty("triggerTarget");
        String activators = mapObject.getCustomProperty("triggerActivators");
        HashMap<String, String> triggerArguments = new HashMap<String, String>();
        for (Property property : mapObject.getAllCustomProperties()) {
            if (!MapObjectProperty.isCustom(property.getName())) continue;
            triggerArguments.put(property.getName(), property.getValue());
        }
        Trigger trigger = new Trigger(act, message, mapObject.getCustomPropertyBool("triggerOneTime"), triggerArguments);
        this.loadProperties(trigger, mapObject);
        for (int target : ArrayUtilities.getIntegerArray(targets)) {
            if (target == 0) continue;
            trigger.addTarget(target);
        }
        for (int activator : ArrayUtilities.getIntegerArray(activators)) {
            if (activator == 0) continue;
            trigger.addActivator(activator);
        }
        trigger.setCooldown(mapObject.getCustomPropertyInt("triggerCooldown"));
        Collection<IEntity> collection = super.load(mapObject);
        collection.add(trigger);
        return collection;
    }
}

