/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.Direction;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.Spawnpoint;
import java.util.Collection;

public class SpawnpointMapObjectLoader
extends MapObjectLoader {
    protected SpawnpointMapObjectLoader() {
        super(MapObjectType.SPAWNPOINT);
    }

    @Override
    public Collection<IEntity> load(IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.SPAWNPOINT) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + SpawnpointMapObjectLoader.class);
        }
        Direction direction = mapObject.getCustomProperty("spawnDirection") != null ? Direction.valueOf(mapObject.getCustomProperty("spawnDirection")) : Direction.DOWN;
        Spawnpoint spawn = new Spawnpoint(direction);
        this.loadProperties(spawn, mapObject);
        String spawnType = mapObject.getCustomProperty("spawnType");
        spawn.setSpawnType(spawnType);
        Collection<IEntity> entities = super.load(mapObject);
        entities.add(spawn);
        return entities;
    }
}

