/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import de.gurkenlabs.litiengine.attributes.Modification;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Material;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.Collection;

public class PropMapObjectLoader
extends MapObjectLoader {
    protected PropMapObjectLoader() {
        super(MapObjectType.PROP);
    }

    @Override
    public Collection<IEntity> load(IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.PROP) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + PropMapObjectLoader.class);
        }
        Material material = mapObject.getCustomProperty("material") == null ? Material.UNDEFINED : Material.valueOf(mapObject.getCustomProperty("material"));
        Prop prop = this.createNewProp(mapObject, mapObject.getCustomProperty("spritesheetName"), material);
        this.loadProperties(prop, mapObject);
        this.loadCollisionProperties(prop, mapObject);
        Rotation rotation = mapObject.getCustomProperty("rotationSprite") == null ? Rotation.NONE : Rotation.valueOf(mapObject.getCustomProperty("rotationSprite"));
        prop.setSpriteRotation(rotation);
        prop.setIndestructible(mapObject.getCustomPropertyBool("indestructible"));
        AttributeModifier mod = new AttributeModifier(Modification.SET, mapObject.getCustomPropertyInt("health"));
        prop.getAttributes().getHealth().modifyMaxBaseValue(mod);
        prop.getAttributes().getHealth().modifyBaseValue(mod);
        prop.setAddShadow(mapObject.getCustomPropertyBool("addShadow"));
        prop.setFlipHorizontally(mapObject.getCustomPropertyBool("flipHorizontally"));
        prop.setFlipVertically(mapObject.getCustomPropertyBool("flipVertically"));
        prop.setTeam(mapObject.getCustomPropertyInt("team"));
        Collection<IEntity> entities = super.load(mapObject);
        entities.add(prop);
        return entities;
    }

    protected Prop createNewProp(IMapObject mapObject, String spriteSheetName, Material material) {
        Prop prop = new Prop(mapObject.getLocation(), spriteSheetName, material);
        prop.setObstacle(mapObject.getCustomPropertyBool("isObstacle"));
        return prop;
    }
}

