/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.graphics.LightSource;
import java.awt.Color;
import java.util.Collection;

public class LightSourceMapObjectLoader
extends MapObjectLoader {
    protected LightSourceMapObjectLoader() {
        super(MapObjectType.LIGHTSOURCE);
    }

    @Override
    public Collection<IEntity> load(IMapObject mapObject) {
        String lightType;
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.LIGHTSOURCE) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + LightSourceMapObjectLoader.class);
        }
        int alpha = mapObject.getCustomPropertyInt("lightBrightness");
        int intensity = mapObject.getCustomPropertyInt("lightIntensity", 100);
        Color color = mapObject.getCustomPropertyColor("lightColor");
        boolean active = mapObject.getCustomPropertyBool("lightActive", true);
        String lightShape = mapObject.getCustomProperty("lightShape");
        if (color == null || lightShape == null) {
            return super.load(mapObject);
        }
        switch (lightShape) {
            case "ellipse": {
                lightType = "ellipse";
                break;
            }
            case "rectangle": {
                lightType = "rectangle";
                break;
            }
            default: {
                lightType = "ellipse";
            }
        }
        LightSource light = new LightSource(intensity, new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha), lightType, active);
        this.loadProperties(light, mapObject);
        Collection<IEntity> entities = super.load(mapObject);
        entities.add(light);
        return entities;
    }
}

