/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.configuration.Quality;
import de.gurkenlabs.litiengine.entities.CollisionBox;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.entities.Trigger;
import de.gurkenlabs.litiengine.entities.ai.IEntityController;
import de.gurkenlabs.litiengine.environment.CollisionBoxMapObjectLoader;
import de.gurkenlabs.litiengine.environment.CreatureMapObjectLoader;
import de.gurkenlabs.litiengine.environment.DecorMobMapObjectLoader;
import de.gurkenlabs.litiengine.environment.EmitterMapObjectLoader;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.IMapObjectLoader;
import de.gurkenlabs.litiengine.environment.LightSourceMapObjectLoader;
import de.gurkenlabs.litiengine.environment.MapAreaMapObjectLoader;
import de.gurkenlabs.litiengine.environment.PropMapObjectLoader;
import de.gurkenlabs.litiengine.environment.SpawnpointMapObjectLoader;
import de.gurkenlabs.litiengine.environment.StaticShadowMapObjectLoader;
import de.gurkenlabs.litiengine.environment.TriggerMapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.MapArea;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.environment.tilemap.Spawnpoint;
import de.gurkenlabs.litiengine.environment.tilemap.TmxMapLoader;
import de.gurkenlabs.litiengine.graphics.AmbientLight;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.LightSource;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.StaticShadow;
import de.gurkenlabs.litiengine.graphics.StaticShadowLayer;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import de.gurkenlabs.litiengine.graphics.animation.IAnimationController;
import de.gurkenlabs.litiengine.graphics.particles.Emitter;
import de.gurkenlabs.litiengine.physics.IMovementController;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Environment
implements IEnvironment {
    private static final Map<String, IMapObjectLoader> mapObjectLoaders = new ConcurrentHashMap<String, IMapObjectLoader>();
    private final Map<Integer, ICombatEntity> combatEntities;
    private final Map<RenderType, Map<Integer, IEntity>> entities;
    private final Map<String, List<IEntity>> entitiesByTag = new ConcurrentHashMap<String, List<IEntity>>();
    private final List<Consumer<Graphics2D>> entitiesRenderedConsumers;
    private final List<Consumer<IEnvironment>> initializedConsumers;
    private final List<Consumer<IEnvironment>> loadedConsumers;
    private final List<Consumer<IEntity>> entityAddedConsumers;
    private final List<Consumer<IEntity>> entityRemovedConsumers;
    private final List<Consumer<Graphics2D>> overlayRenderedConsumer;
    private final List<Consumer<Graphics2D>> mapRenderedConsumer;
    private final List<IRenderable> groundRenderable;
    private final Collection<CollisionBox> colliders;
    private final Collection<LightSource> lightSources;
    private final Collection<StaticShadow> staticShadows;
    private final Collection<Trigger> triggers;
    private final Collection<Prop> props;
    private final Collection<Emitter> emitters;
    private final Collection<Creature> creatures;
    private final Collection<MapArea> mapAreas;
    private final Map<Integer, IMobileEntity> mobileEntities;
    private final List<IRenderable> overlayRenderable;
    private final List<Spawnpoint> spawnPoints;
    private AmbientLight ambientLight;
    private StaticShadowLayer staticShadowLayer;
    private boolean loaded;
    private boolean initialized;
    private IMap map;
    private int localIdSequence = 0;
    private int mapIdSequence;

    public Environment(IMap map) {
        this();
        this.map = map;
        this.mapIdSequence = MapUtilities.getMaxMapId(this.getMap());
        Game.getPhysicsEngine().setBounds(new Rectangle(this.getMap().getSizeInPixels()));
    }

    public Environment(String mapPath) {
        this();
        IMap loadedMap = Game.getMap(FileUtilities.getFileName(mapPath));
        if (loadedMap == null) {
            TmxMapLoader tmxLoader = new TmxMapLoader();
            this.map = tmxLoader.loadMap(mapPath);
        } else {
            this.map = loadedMap;
        }
        this.mapIdSequence = MapUtilities.getMaxMapId(this.getMap());
        Game.getPhysicsEngine().setBounds(new Rectangle(this.getMap().getSizeInPixels()));
    }

    private Environment() {
        this.entities = new ConcurrentHashMap<RenderType, Map<Integer, IEntity>>();
        this.entities.put(RenderType.NONE, new ConcurrentHashMap());
        this.entities.put(RenderType.GROUND, new ConcurrentHashMap());
        this.entities.put(RenderType.NORMAL, new ConcurrentHashMap());
        this.entities.put(RenderType.OVERLAY, new ConcurrentHashMap());
        this.combatEntities = new ConcurrentHashMap<Integer, ICombatEntity>();
        this.mobileEntities = new ConcurrentHashMap<Integer, IMobileEntity>();
        this.lightSources = Collections.newSetFromMap(new ConcurrentHashMap());
        this.colliders = Collections.newSetFromMap(new ConcurrentHashMap());
        this.triggers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.mapAreas = Collections.newSetFromMap(new ConcurrentHashMap());
        this.staticShadows = Collections.newSetFromMap(new ConcurrentHashMap());
        this.props = Collections.newSetFromMap(new ConcurrentHashMap());
        this.emitters = Collections.newSetFromMap(new ConcurrentHashMap());
        this.creatures = Collections.newSetFromMap(new ConcurrentHashMap());
        this.mapRenderedConsumer = new CopyOnWriteArrayList<Consumer<Graphics2D>>();
        this.entitiesRenderedConsumers = new CopyOnWriteArrayList<Consumer<Graphics2D>>();
        this.overlayRenderedConsumer = new CopyOnWriteArrayList<Consumer<Graphics2D>>();
        this.initializedConsumers = new CopyOnWriteArrayList<Consumer<IEnvironment>>();
        this.loadedConsumers = new CopyOnWriteArrayList<Consumer<IEnvironment>>();
        this.entityAddedConsumers = new CopyOnWriteArrayList<Consumer<IEntity>>();
        this.entityRemovedConsumers = new CopyOnWriteArrayList<Consumer<IEntity>>();
        this.spawnPoints = new CopyOnWriteArrayList<Spawnpoint>();
        this.groundRenderable = new CopyOnWriteArrayList<IRenderable>();
        this.overlayRenderable = new CopyOnWriteArrayList<IRenderable>();
    }

    @Override
    public void add(IEntity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getMapId() == 0) {
            entity.setMapId(this.getLocalMapId());
        }
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            this.getGroundRenderables().add(emitter.getGroundRenderable());
            this.getOverlayRenderables().add(emitter.getOverlayRenderable());
            this.emitters.add(emitter);
        }
        if (entity instanceof ICombatEntity) {
            this.combatEntities.put(entity.getMapId(), (ICombatEntity)entity);
        }
        if (entity instanceof IMobileEntity) {
            this.mobileEntities.put(entity.getMapId(), (IMobileEntity)entity);
        }
        if (entity instanceof Prop) {
            this.props.add((Prop)entity);
        }
        if (entity instanceof Creature) {
            this.creatures.add((Creature)entity);
        }
        if (entity instanceof CollisionBox) {
            this.colliders.add((CollisionBox)entity);
        }
        if (entity instanceof LightSource) {
            this.lightSources.add((LightSource)entity);
        }
        if (entity instanceof Trigger) {
            this.triggers.add((Trigger)entity);
        }
        if (entity instanceof Spawnpoint) {
            this.spawnPoints.add((Spawnpoint)entity);
        }
        if (entity instanceof StaticShadow) {
            this.staticShadows.add((StaticShadow)entity);
        } else if (entity instanceof MapArea) {
            this.mapAreas.add((MapArea)entity);
        }
        for (String string : entity.getTags()) {
            String tag;
            if (string == null || (tag = string.trim().toLowerCase()).isEmpty()) continue;
            if (this.entitiesByTag.containsKey(tag)) {
                this.entitiesByTag.get(tag).add(entity);
                continue;
            }
            this.entitiesByTag.put(tag, new CopyOnWriteArrayList());
            this.entitiesByTag.get(tag).add(entity);
        }
        if (this.loaded) {
            this.load(entity);
        }
        this.entities.get((Object)entity.getRenderType()).put(entity.getMapId(), entity);
        for (Consumer consumer : this.entityAddedConsumers) {
            consumer.accept(entity);
        }
    }

    @Override
    public void add(IRenderable renderable, RenderType type) {
        switch (type) {
            case GROUND: {
                this.getGroundRenderables().add(renderable);
                break;
            }
            case OVERLAY: {
                this.getOverlayRenderables().add(renderable);
                break;
            }
        }
    }

    @Override
    public void clear() {
        Game.getPhysicsEngine().clear();
        this.dispose(this.getEntities());
        this.dispose(this.getTriggers());
        this.getCombatEntities().clear();
        this.getMobileEntities().clear();
        this.getLightSources().clear();
        this.getCollisionBoxes().clear();
        this.getSpawnPoints().clear();
        this.getAreas().clear();
        this.getTriggers().clear();
        this.entities.get((Object)RenderType.NONE).clear();
        this.entities.get((Object)RenderType.GROUND).clear();
        this.entities.get((Object)RenderType.NORMAL).clear();
        this.entities.get((Object)RenderType.OVERLAY).clear();
        this.initialized = false;
    }

    @Override
    public List<ICombatEntity> findCombatEntities(Shape shape) {
        return this.findCombatEntities(shape, entity -> true);
    }

    @Override
    public List<ICombatEntity> findCombatEntities(Shape shape, Predicate<ICombatEntity> condition) {
        ArrayList<ICombatEntity> foundCombatEntities = new ArrayList<ICombatEntity>();
        if (shape == null) {
            return foundCombatEntities;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            for (ICombatEntity combatEntity : this.getCombatEntities().stream().filter(condition).collect(Collectors.toList())) {
                if (!combatEntity.getHitBox().intersects(rect)) continue;
                foundCombatEntities.add(combatEntity);
            }
            return foundCombatEntities;
        }
        for (ICombatEntity combatEntity : this.getCombatEntities().stream().filter(condition).collect(Collectors.toList())) {
            if (!combatEntity.getHitBox().intersects(shape.getBounds()) || !GeometricUtilities.shapeIntersects(combatEntity.getHitBox(), shape)) continue;
            foundCombatEntities.add(combatEntity);
        }
        return foundCombatEntities;
    }

    @Override
    public List<IEntity> findEntities(Shape shape) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        if (shape == null) {
            return foundEntities;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            for (IEntity entity : this.getEntities()) {
                if (!entity.getBoundingBox().intersects(rect)) continue;
                foundEntities.add(entity);
            }
            return foundEntities;
        }
        for (IEntity entity : this.getEntities()) {
            if (!entity.getBoundingBox().intersects(shape.getBounds()) || !GeometricUtilities.shapeIntersects(entity.getBoundingBox(), shape)) continue;
            foundEntities.add(entity);
        }
        return foundEntities;
    }

    @Override
    public IEntity get(int mapId) {
        IEntity entity = this.entities.get((Object)RenderType.GROUND).get(mapId);
        if (entity != null) {
            return entity;
        }
        entity = this.entities.get((Object)RenderType.NORMAL).get(mapId);
        if (entity != null) {
            return entity;
        }
        entity = this.entities.get((Object)RenderType.OVERLAY).get(mapId);
        if (entity != null) {
            return entity;
        }
        entity = this.entities.get((Object)RenderType.NONE).get(mapId);
        if (entity != null) {
            return entity;
        }
        return null;
    }

    @Override
    public IEntity get(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (IEntity entity : this.entities.get((Object)RenderType.GROUND).values()) {
            if (entity.getName() == null || !entity.getName().equals(name)) continue;
            return entity;
        }
        for (IEntity entity : this.entities.get((Object)RenderType.NORMAL).values()) {
            if (entity.getName() == null || !entity.getName().equals(name)) continue;
            return entity;
        }
        for (IEntity entity : this.entities.get((Object)RenderType.OVERLAY).values()) {
            if (entity.getName() == null || !entity.getName().equals(name)) continue;
            return entity;
        }
        for (IEntity entity : this.entities.get((Object)RenderType.NONE).values()) {
            if (entity.getName() == null || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public Collection<IEntity> getByTag(String tag) {
        if (this.entitiesByTag.containsKey(tag.toLowerCase())) {
            return this.entitiesByTag.get(tag);
        }
        return new ArrayList<IEntity>();
    }

    @Override
    public <T extends IEntity> Collection<T> getByTag(Class<T> clss, String rawTag) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        String tag = rawTag.toLowerCase();
        if (!this.entitiesByTag.containsKey(tag.toLowerCase())) {
            return foundEntities;
        }
        for (IEntity ent : this.entitiesByTag.get(tag)) {
            if (!clss.isInstance(ent)) continue;
            foundEntities.add(ent);
        }
        return foundEntities;
    }

    @Override
    public AmbientLight getAmbientLight() {
        return this.ambientLight;
    }

    @Override
    public Collection<MapArea> getAreas() {
        return this.mapAreas;
    }

    @Override
    public MapArea getArea(int mapId) {
        return Environment.getById(this.getAreas(), mapId);
    }

    @Override
    public MapArea getArea(String name) {
        return Environment.getByName(this.getAreas(), name);
    }

    @Override
    public Collection<Emitter> getEmitters() {
        return this.emitters;
    }

    @Override
    public Emitter getEmitter(int mapId) {
        return Environment.getById(this.getEmitters(), mapId);
    }

    @Override
    public Emitter getEmitter(String name) {
        return Environment.getByName(this.getEmitters(), name);
    }

    @Override
    public Collection<CollisionBox> getCollisionBoxes() {
        return this.colliders;
    }

    @Override
    public CollisionBox getCollisionBox(int mapId) {
        return Environment.getById(this.getCollisionBoxes(), mapId);
    }

    @Override
    public CollisionBox getCollisionBox(String name) {
        return Environment.getByName(this.getCollisionBoxes(), name);
    }

    @Override
    public Collection<ICombatEntity> getCombatEntities() {
        return this.combatEntities.values();
    }

    @Override
    public ICombatEntity getCombatEntity(int mapId) {
        return Environment.getById(this.getCombatEntities(), mapId);
    }

    @Override
    public ICombatEntity getCombatEntity(String name) {
        return Environment.getByName(this.getCombatEntities(), name);
    }

    @Override
    public Collection<IEntity> getEntities() {
        ArrayList<IEntity> ent = new ArrayList<IEntity>();
        ent.addAll(this.entities.get((Object)RenderType.NONE).values());
        ent.addAll(this.entities.get((Object)RenderType.GROUND).values());
        ent.addAll(this.entities.get((Object)RenderType.NORMAL).values());
        ent.addAll(this.entities.get((Object)RenderType.OVERLAY).values());
        return ent;
    }

    @Override
    public Collection<IEntity> getEntities(RenderType renderType) {
        return this.entities.get((Object)renderType).values();
    }

    @Override
    public <T extends IEntity> Collection<T> getEntitiesByType(Class<T> cls) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        for (IEntity ent : this.getEntities()) {
            if (!cls.isInstance(ent)) continue;
            foundEntities.add(ent);
        }
        return foundEntities;
    }

    public Collection<IRenderable> getGroundRenderables() {
        return this.groundRenderable;
    }

    @Override
    public Collection<LightSource> getLightSources() {
        return this.lightSources;
    }

    @Override
    public LightSource getLightSource(int mapId) {
        return Environment.getById(this.getLightSources(), mapId);
    }

    @Override
    public LightSource getLightSource(String name) {
        return Environment.getByName(this.getLightSources(), name);
    }

    @Override
    public synchronized int getLocalMapId() {
        return --this.localIdSequence;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public Collection<IMobileEntity> getMobileEntities() {
        return this.mobileEntities.values();
    }

    @Override
    public IMobileEntity getMobileEntity(int mapId) {
        return Environment.getById(this.getMobileEntities(), mapId);
    }

    @Override
    public IMobileEntity getMobileEntity(String name) {
        return Environment.getByName(this.getMobileEntities(), name);
    }

    @Override
    public synchronized int getNextMapId() {
        return ++this.mapIdSequence;
    }

    public List<IRenderable> getOverlayRenderables() {
        return this.overlayRenderable;
    }

    @Override
    public Collection<Prop> getProps() {
        return this.props;
    }

    @Override
    public Prop getProp(int mapId) {
        return Environment.getById(this.getProps(), mapId);
    }

    @Override
    public Prop getProp(String name) {
        return Environment.getByName(this.getProps(), name);
    }

    @Override
    public Creature getCreature(int mapId) {
        return Environment.getById(this.getCreatures(), mapId);
    }

    @Override
    public Creature getCreature(String name) {
        return Environment.getByName(this.getCreatures(), name);
    }

    @Override
    public Collection<Creature> getCreatures() {
        return this.creatures;
    }

    @Override
    public Spawnpoint getSpawnpoint(int mapId) {
        return (Spawnpoint)Environment.getById(this.getSpawnPoints(), mapId);
    }

    @Override
    public Spawnpoint getSpawnpoint(String name) {
        return (Spawnpoint)Environment.getByName(this.getSpawnPoints(), name);
    }

    public List<Spawnpoint> getSpawnPoints() {
        return this.spawnPoints;
    }

    @Override
    public Collection<StaticShadow> getStaticShadows() {
        return this.staticShadows;
    }

    @Override
    public StaticShadow getStaticShadow(int mapId) {
        return Environment.getById(this.getStaticShadows(), mapId);
    }

    @Override
    public StaticShadow getStaticShadow(String name) {
        return Environment.getByName(this.getStaticShadows(), name);
    }

    @Override
    public StaticShadowLayer getStaticShadowLayer() {
        return this.staticShadowLayer;
    }

    @Override
    public Trigger getTrigger(int mapId) {
        return Environment.getById(this.getTriggers(), mapId);
    }

    @Override
    public Trigger getTrigger(String name) {
        return Environment.getByName(this.getTriggers(), name);
    }

    @Override
    public Collection<Trigger> getTriggers() {
        return this.triggers;
    }

    @Override
    public List<String> getUsedTags() {
        List<String> tags = this.entitiesByTag.keySet().stream().collect(Collectors.toList());
        Collections.sort(tags);
        return tags;
    }

    @Override
    public final void init() {
        if (this.initialized) {
            return;
        }
        this.loadMapObjects();
        this.addStaticShadows();
        this.addAmbientLight();
        for (Consumer<IEnvironment> cons : this.initializedConsumers) {
            cons.accept(this);
        }
        this.initialized = true;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void load() {
        this.init();
        if (this.loaded) {
            return;
        }
        Game.getPhysicsEngine().setBounds(new Rectangle2D.Double(0.0, 0.0, this.getMap().getSizeInPixels().getWidth(), this.getMap().getSizeInPixels().getHeight()));
        for (IEntity iEntity : this.getEntities()) {
            this.load(iEntity);
        }
        this.loaded = true;
        for (Consumer consumer : this.loadedConsumers) {
            consumer.accept(this);
        }
    }

    @Override
    public void loadFromMap(int mapId) {
        for (IMapObjectLayer layer : this.getMap().getMapObjectLayers()) {
            Optional<IMapObject> opt = layer.getMapObjects().stream().filter(mapObject -> mapObject.getType() != null && !mapObject.getType().isEmpty() && mapObject.getId() == mapId).findFirst();
            if (!opt.isPresent()) continue;
            IMapObject mapObject2 = opt.get();
            this.addMapObject(mapObject2);
            if (MapObjectType.get(mapObject2.getType()) != MapObjectType.STATICSHADOW && MapObjectType.get(mapObject2.getType()) != MapObjectType.LIGHTSOURCE) break;
            this.addStaticShadows();
            break;
        }
    }

    @Override
    public void onEntityRemoved(Consumer<IEntity> consumer) {
        this.entityRemovedConsumers.add(consumer);
    }

    @Override
    public void onEntityAdded(Consumer<IEntity> consumer) {
        this.entityAddedConsumers.add(consumer);
    }

    @Override
    public void onEntitiesRendered(Consumer<Graphics2D> consumer) {
        this.entitiesRenderedConsumers.add(consumer);
    }

    @Override
    public void onInitialized(Consumer<IEnvironment> consumer) {
        this.initializedConsumers.add(consumer);
    }

    @Override
    public void onLoaded(Consumer<IEnvironment> consumer) {
        this.loadedConsumers.add(consumer);
    }

    @Override
    public void onMapRendered(Consumer<Graphics2D> consumer) {
        this.mapRenderedConsumer.add(consumer);
    }

    @Override
    public void onOverlayRendered(Consumer<Graphics2D> consumer) {
        this.overlayRenderedConsumer.add(consumer);
    }

    public static void registerMapObjectLoader(String mapObjectType, IMapObjectLoader mapObjectLoader) {
        mapObjectLoaders.put(mapObjectType, mapObjectLoader);
    }

    public static void registerMapObjectLoader(MapObjectType mapObjectType, IMapObjectLoader mapObjectLoader) {
        Environment.registerMapObjectLoader(mapObjectType.name(), mapObjectLoader);
    }

    @Override
    public void reloadFromMap(int mapId) {
        this.remove(mapId);
        this.loadFromMap(mapId);
    }

    @Override
    public void remove(IEntity entity) {
        if (entity == null) {
            return;
        }
        if (this.entities.get((Object)entity.getRenderType()) != null) {
            this.entities.get((Object)entity.getRenderType()).entrySet().removeIf(e -> ((IEntity)e.getValue()).getMapId() == entity.getMapId());
        }
        for (String string : entity.getTags()) {
            if (!this.entitiesByTag.containsKey(string)) continue;
            this.entitiesByTag.get(string).remove(entity);
            if (!this.entitiesByTag.get(string).isEmpty()) continue;
            this.entitiesByTag.remove(string);
        }
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            this.groundRenderable.remove(emitter.getGroundRenderable());
            this.overlayRenderable.remove(emitter.getOverlayRenderable());
            this.emitters.remove(emitter);
        }
        if (entity instanceof MapArea) {
            this.mapAreas.remove(entity);
        }
        if (entity instanceof Prop) {
            this.props.remove(entity);
        }
        if (entity instanceof Creature) {
            this.creatures.remove(entity);
        }
        if (entity instanceof CollisionBox) {
            this.colliders.remove(entity);
            this.staticShadows.removeIf(x -> x.getOrigin() != null && x.getOrigin().equals(entity));
        }
        if (entity instanceof LightSource) {
            this.lightSources.remove(entity);
            this.addStaticShadows();
        }
        if (entity instanceof Trigger) {
            this.triggers.remove(entity);
        }
        if (entity instanceof Spawnpoint) {
            this.spawnPoints.remove(entity);
        }
        if (entity instanceof StaticShadow) {
            this.staticShadows.remove(entity);
            this.addStaticShadows();
        }
        if (entity instanceof IMobileEntity) {
            this.mobileEntities.values().remove(entity);
        }
        if (entity instanceof ICombatEntity) {
            this.combatEntities.values().remove(entity);
        }
        this.unload(entity);
        for (Consumer consumer : this.entityRemovedConsumers) {
            consumer.accept(entity);
        }
    }

    @Override
    public void remove(int mapId) {
        IEntity ent = this.get(mapId);
        if (ent == null) {
            return;
        }
        this.remove(ent);
    }

    @Override
    public <T extends IEntity> void remove(Collection<T> entities) {
        if (entities == null) {
            return;
        }
        for (IEntity ent : entities) {
            this.remove(ent);
        }
    }

    @Override
    public void removeRenderable(IRenderable renderable) {
        if (this.getGroundRenderables().contains(renderable)) {
            this.getGroundRenderables().remove(renderable);
        }
        if (this.getOverlayRenderables().contains(renderable)) {
            this.getOverlayRenderables().remove(renderable);
        }
    }

    @Override
    public void render(Graphics2D g) {
        g.scale(Game.getCamera().getRenderScale(), Game.getCamera().getRenderScale());
        Game.getRenderEngine().renderMap(g, this.getMap());
        this.informConsumers(g, this.mapRenderedConsumer);
        for (IRenderable rend : this.getGroundRenderables()) {
            rend.render(g);
        }
        Game.getRenderEngine().renderEntities(g, this.entities.get((Object)RenderType.GROUND).values(), false);
        if (Game.getConfiguration().graphics().getGraphicQuality() == Quality.VERYHIGH) {
            Game.getRenderEngine().renderEntities(g, this.getLightSources(), false);
        }
        Game.getRenderEngine().renderEntities(g, this.entities.get((Object)RenderType.NORMAL).values());
        this.informConsumers(g, this.entitiesRenderedConsumers);
        Game.getRenderEngine().renderLayers(g, this.getMap(), RenderType.OVERLAY);
        Game.getRenderEngine().renderEntities(g, this.entities.get((Object)RenderType.OVERLAY).values(), false);
        if (this.getStaticShadows().stream().anyMatch(x -> x.getShadowType() != StaticShadowType.NONE)) {
            this.getStaticShadowLayer().render(g);
        }
        if (Game.getConfiguration().graphics().getGraphicQuality().ordinal() >= Quality.MEDIUM.ordinal() && this.getAmbientLight() != null && this.getAmbientLight().getAlpha() != 0) {
            this.getAmbientLight().render(g);
        }
        for (IRenderable rend : this.getOverlayRenderables()) {
            rend.render(g);
        }
        this.informConsumers(g, this.overlayRenderedConsumer);
        g.scale(1.0 / (double)Game.getCamera().getRenderScale(), 1.0 / (double)Game.getCamera().getRenderScale());
    }

    @Override
    public void unload() {
        if (!this.loaded) {
            return;
        }
        for (IEntity entity : this.getEntities()) {
            this.unload(entity);
        }
        this.loaded = false;
    }

    protected void addMapObject(IMapObject mapObject) {
        if (mapObjectLoaders.containsKey(mapObject.getType())) {
            Collection<IEntity> loadedEntities = mapObjectLoaders.get(mapObject.getType()).load(mapObject);
            for (IEntity entity : loadedEntities) {
                if (entity == null) continue;
                this.add(entity);
            }
        }
    }

    private static <T extends IEntity> T getById(Collection<T> entities, int mapId) {
        for (IEntity m : entities) {
            if (m.getMapId() != mapId) continue;
            return (T)m;
        }
        return null;
    }

    private static <T extends IEntity> T getByName(Collection<T> entities, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (IEntity m : entities) {
            if (m.getName() == null || !m.getName().equals(name)) continue;
            return (T)m;
        }
        return null;
    }

    private void addAmbientLight() {
        int ambientAlpha = this.getMap().getCustomPropertyInt("AMBIENTALPHA");
        Color ambientColor = this.getMap().getCustomPropertyColor("AMBIENTLIGHT", Color.WHITE);
        this.ambientLight = new AmbientLight(this, ambientColor, ambientAlpha);
    }

    private void addStaticShadows() {
        int alpha = this.getMap().getCustomPropertyInt("SHADOWALPHA", 75);
        Color color = this.getMap().getCustomPropertyColor("SHADOWCOLOR", StaticShadow.DEFAULT_COLOR);
        this.staticShadowLayer = new StaticShadowLayer((IEnvironment)this, alpha, color);
    }

    private void dispose(Collection<? extends IEntity> entities) {
        for (IEntity iEntity : entities) {
            if (iEntity instanceof IUpdateable) {
                Game.getLoop().detach((IUpdateable)((Object)iEntity));
            }
            Game.getEntityControllerManager().disposeControllers(iEntity);
        }
    }

    private void informConsumers(Graphics2D g, List<Consumer<Graphics2D>> consumers) {
        for (Consumer<Graphics2D> consumer : consumers) {
            consumer.accept(g);
        }
    }

    private void load(IEntity entity) {
        IEntityController<? extends IEntity> controller;
        IMovementController<? extends IMobileEntity> movementController;
        this.loadPhysicsEntity(entity);
        this.loadUpdatableOrEmitterEntity(entity);
        IAnimationController animation = Game.getEntityControllerManager().getAnimationController(entity);
        if (animation != null) {
            Game.getLoop().attach(animation);
        }
        if (entity instanceof IMobileEntity && (movementController = Game.getEntityControllerManager().getMovementController((IMobileEntity)entity)) != null) {
            Game.getLoop().attach(movementController);
        }
        if ((controller = Game.getEntityControllerManager().getAIController(entity)) != null) {
            Game.getLoop().attach(controller);
        }
    }

    private void loadPhysicsEntity(IEntity entity) {
        ICollisionEntity coll;
        if (entity instanceof CollisionBox) {
            CollisionBox coll2 = (CollisionBox)entity;
            if (coll2.isObstacle()) {
                Game.getPhysicsEngine().add(coll2.getBoundingBox());
            } else {
                Game.getPhysicsEngine().add(coll2);
            }
        } else if (entity instanceof ICollisionEntity && (coll = (ICollisionEntity)entity).hasCollision()) {
            Game.getPhysicsEngine().add(coll);
        }
    }

    private void loadUpdatableOrEmitterEntity(IEntity entity) {
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            if (emitter.isActivateOnInit()) {
                emitter.activate();
            }
        } else if (entity instanceof IUpdateable) {
            Game.getLoop().attach((IUpdateable)((Object)entity));
        }
    }

    private void loadMapObjects() {
        for (IMapObjectLayer layer : this.getMap().getMapObjectLayers()) {
            for (IMapObject mapObject : layer.getMapObjects()) {
                if (mapObject.getType() == null || mapObject.getType().isEmpty()) continue;
                this.addMapObject(mapObject);
            }
        }
    }

    private static void registerDefaultMapObjectLoaders() {
        Environment.registerMapObjectLoader(MapObjectType.PROP, (IMapObjectLoader)new PropMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.COLLISIONBOX, (IMapObjectLoader)new CollisionBoxMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.TRIGGER, (IMapObjectLoader)new TriggerMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.DECORMOB, (IMapObjectLoader)new DecorMobMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.EMITTER, (IMapObjectLoader)new EmitterMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.LIGHTSOURCE, (IMapObjectLoader)new LightSourceMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.SPAWNPOINT, (IMapObjectLoader)new SpawnpointMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.AREA, (IMapObjectLoader)new MapAreaMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.STATICSHADOW, (IMapObjectLoader)new StaticShadowMapObjectLoader());
        Environment.registerMapObjectLoader(MapObjectType.CREATURE, (IMapObjectLoader)new CreatureMapObjectLoader());
    }

    private void unload(IEntity entity) {
        IMovementController<? extends IMobileEntity> movementController;
        IAnimationController animation;
        IEntityController<? extends IEntity> controller;
        ICollisionEntity coll;
        if (entity instanceof CollisionBox) {
            coll = (CollisionBox)entity;
            if (((CollisionBox)coll).isObstacle()) {
                Game.getPhysicsEngine().remove(((Entity)((Object)coll)).getBoundingBox());
            } else {
                Game.getPhysicsEngine().remove(coll);
            }
        } else if (entity instanceof ICollisionEntity) {
            coll = (ICollisionEntity)entity;
            Game.getPhysicsEngine().remove(coll);
        }
        if (entity instanceof IUpdateable) {
            Game.getLoop().detach((IUpdateable)((Object)entity));
        }
        if ((controller = Game.getEntityControllerManager().getAIController(entity)) != null) {
            Game.getLoop().detach(controller);
        }
        if ((animation = Game.getEntityControllerManager().getAnimationController(entity)) != null) {
            Game.getLoop().detach(animation);
        }
        if (entity instanceof IMobileEntity && (movementController = Game.getEntityControllerManager().getMovementController((IMobileEntity)entity)) != null) {
            Game.getLoop().detach(movementController);
        }
        if (entity instanceof Emitter) {
            Emitter em = (Emitter)entity;
            em.deactivate();
        }
    }

    static {
        Environment.registerDefaultMapObjectLoaders();
    }
}

