/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.IEntitySpawner;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.tilemap.Spawnpoint;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class EntitySpawner<T extends IEntity>
implements IEntitySpawner<T> {
    private static final Logger log = Logger.getLogger(EntitySpawner.class.getName());
    private int amount;
    private IEnvironment environment;
    private int interval;
    private long lastSpawn;
    private int spawnDelay;
    private IEntitySpawner.SpawnMode spawnMode;
    private List<Spawnpoint> spawnpoints;

    public EntitySpawner(IEnvironment environment, IGameLoop loop, List<Spawnpoint> spawnpoints, int interval, int amount) {
        this.environment = environment;
        this.interval = interval;
        this.spawnDelay = 1000;
        this.amount = amount;
        this.spawnpoints = spawnpoints;
        loop.attach(this);
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public int getSpawnDelay() {
        return this.spawnDelay;
    }

    @Override
    public IEntitySpawner.SpawnMode getSpawnMode() {
        return this.spawnMode;
    }

    @Override
    public List<Spawnpoint> getSpawnPoints() {
        return this.spawnpoints;
    }

    @Override
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Override
    public void setSpawnDelay(int delay) {
        this.spawnDelay = delay;
    }

    @Override
    public void setSpawnMode(IEntitySpawner.SpawnMode mode) {
        this.spawnMode = mode;
    }

    @Override
    public void update() {
        if (Game.getLoop().getDeltaTime(this.lastSpawn) < (long)this.getInterval()) {
            return;
        }
        this.spawnNewEntities();
        this.lastSpawn = Game.getLoop().getTicks();
    }

    protected abstract void addToEnvironment(IEnvironment var1, T var2);

    protected void spawnNewEntities() {
        if (this.getSpawnPoints().isEmpty()) {
            return;
        }
        switch (this.getSpawnMode()) {
            case ALLSPAWNPOINTS: {
                for (Spawnpoint spawn : this.getSpawnPoints()) {
                    this.spawn(spawn, this.getAmount());
                }
                break;
            }
            case ONERANDOMSPAWNPOINT: {
                int rnd = new Random().nextInt(this.getSpawnPoints().size());
                this.spawn(this.getSpawnPoints().get(rnd), this.getAmount());
                break;
            }
            case RANDOMSPAWNPOINTS: {
                for (int i = 0; i < this.getAmount(); ++i) {
                    int rnd2 = new Random().nextInt(this.getSpawnPoints().size());
                    this.spawn(this.getSpawnPoints().get(rnd2), 1);
                }
                break;
            }
        }
    }

    private void spawn(Spawnpoint spawnpoint, int amount) {
        new SpawnThread(spawnpoint, amount).start();
    }

    private class SpawnThread
    extends Thread {
        private final int amount;
        private final Spawnpoint point;

        public SpawnThread(Spawnpoint point, int amount) {
            this.point = point;
            this.amount = amount;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.amount; ++i) {
                Object newEntity = EntitySpawner.this.createNew();
                newEntity.setLocation(this.point.getLocation());
                newEntity.setMapId(EntitySpawner.this.environment.getNextMapId());
                EntitySpawner.this.addToEnvironment(EntitySpawner.this.environment, newEntity);
                try {
                    Thread.sleep(EntitySpawner.this.getSpawnDelay());
                    continue;
                }
                catch (InterruptedException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    this.interrupt();
                }
            }
        }
    }
}

