/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.DecorMob;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.Collection;

public class DecorMobMapObjectLoader
extends MapObjectLoader {
    protected DecorMobMapObjectLoader() {
        super(MapObjectType.DECORMOB);
    }

    @Override
    public Collection<IEntity> load(IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.DECORMOB) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + DecorMobMapObjectLoader.class);
        }
        if (mapObject.getCustomProperty("spritesheetName") == null) {
            throw new IllegalArgumentException("A DecorMob requires a spritesheetName to be set.");
        }
        short velocity = (short)(100.0f / Game.getInfo().getDefaultRenderScale());
        if (mapObject.getCustomProperty("decormob-velocity") != null) {
            velocity = Short.parseShort(mapObject.getCustomProperty("decormob-velocity"));
        }
        DecorMob mob = new DecorMob(mapObject.getLocation(), mapObject.getCustomProperty("spritesheetName"), DecorMob.MovementBehavior.get(mapObject.getCustomProperty("decormob-behaviour")), velocity);
        this.loadProperties(mob, mapObject);
        this.loadCollisionProperties(mob, mapObject);
        mob.setIndestructible(mapObject.getCustomPropertyBool("indestructible"));
        Collection<IEntity> entities = super.load(mapObject);
        entities.add(mob);
        return entities;
    }
}

