/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.entities.Direction;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.Collection;

public class CreatureMapObjectLoader
extends MapObjectLoader {
    protected CreatureMapObjectLoader() {
        super(MapObjectType.CREATURE);
    }

    @Override
    public Collection<IEntity> load(IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.CREATURE) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + CreatureMapObjectLoader.class);
        }
        if (mapObject.getCustomProperty("spritesheetName") == null) {
            return super.load(mapObject);
        }
        Creature creature = this.createNewCreature(mapObject, mapObject.getCustomProperty("spawnType"));
        this.loadProperties(creature, mapObject);
        this.loadCollisionProperties(creature, mapObject);
        creature.setFacingDirection(mapObject.getCustomPropertyEnum("spawnDirection", Direction.class, Direction.RIGHT));
        Collection<IEntity> entities = super.load(mapObject);
        entities.add(creature);
        return entities;
    }

    protected Creature createNewCreature(IMapObject mapObject, String spawnType) {
        return new Creature(mapObject.getCustomProperty("spritesheetName"));
    }
}

