/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities.ai;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.ai.IEntityController;
import de.gurkenlabs.litiengine.graphics.animation.IAnimationController;
import de.gurkenlabs.litiengine.physics.IMovementController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EntityControllerManager {
    private final Map<IEntity, IEntityController<? extends IEntity>> aiControllers = new ConcurrentHashMap<IEntity, IEntityController<? extends IEntity>>();
    private final Map<IEntity, IAnimationController> animationControllers = new ConcurrentHashMap<IEntity, IAnimationController>();
    private final Map<IEntity, IMovementController<? extends IMobileEntity>> movementControllers = new ConcurrentHashMap<IEntity, IMovementController<? extends IMobileEntity>>();

    public void addController(IEntity entity, IAnimationController controller) {
        if (entity == null || controller == null) {
            return;
        }
        if (this.animationControllers.containsKey(entity)) {
            Game.getLoop().detach(this.getAnimationController(entity));
        }
        this.animationControllers.put(entity, controller);
    }

    public <T extends IEntity> void addController(T entity, IEntityController<T> controller) {
        if (entity == null || controller == null) {
            return;
        }
        if (this.aiControllers.containsKey(entity)) {
            Game.getLoop().detach(this.getAIController(entity));
        }
        this.aiControllers.put(entity, controller);
    }

    public <T extends IMobileEntity> void addController(T entity, IMovementController<T> controller) {
        if (entity == null || controller == null) {
            return;
        }
        if (this.movementControllers.containsKey(entity)) {
            Game.getLoop().detach(this.getMovementController(entity));
        }
        this.movementControllers.put(entity, controller);
    }

    public void disposeControllers(IEntity entity) {
        IAnimationController animationController;
        IMovementController<? extends IMobileEntity> controller;
        IEntityController<? extends IEntity> aiController = this.getAIController(entity);
        if (aiController != null) {
            Game.getLoop().detach(aiController);
            this.aiControllers.remove(entity);
        }
        if (entity instanceof IMobileEntity && (controller = this.getMovementController((IMobileEntity)entity)) != null) {
            Game.getLoop().detach(controller);
            this.movementControllers.remove(entity);
        }
        if ((animationController = this.getAnimationController(entity)) != null) {
            animationController.dispose();
            this.animationControllers.remove(entity);
        }
    }

    public IEntityController<? extends IEntity> getAIController(IEntity entity) {
        if (this.aiControllers.containsKey(entity)) {
            return this.aiControllers.get(entity);
        }
        return null;
    }

    public IAnimationController getAnimationController(IEntity entity) {
        if (this.animationControllers.containsKey(entity)) {
            return this.animationControllers.get(entity);
        }
        return null;
    }

    public IMovementController<? extends IMobileEntity> getMovementController(IMobileEntity entity) {
        if (this.movementControllers.containsKey(entity)) {
            return this.movementControllers.get(entity);
        }
        return null;
    }
}

