/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.AnimationInfo;
import de.gurkenlabs.litiengine.entities.CombatEntity;
import de.gurkenlabs.litiengine.entities.Material;
import de.gurkenlabs.litiengine.entities.PropState;
import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.graphics.animation.PropAnimationController;
import java.awt.geom.Point2D;

@AnimationInfo(spritePrefix="prop-")
public class Prop
extends CombatEntity {
    private Material material;
    private String spritesheetName;
    private boolean isObstacle;
    private boolean addShadow;
    private boolean flipHorizontally;
    private boolean flipVertically;
    private Rotation rotation = Rotation.NONE;

    public Prop(double x, double y, String spritesheetName) {
        this(x, y, spritesheetName, Material.UNDEFINED);
    }

    public Prop(double x, double y, String spritesheetName, Material mat) {
        this(new Point2D.Double(x, y), spritesheetName, mat);
    }

    public Prop(Point2D location, String spritesheetName) {
        this(location, spritesheetName, Material.UNDEFINED);
    }

    public Prop(Point2D location, String spritesheetName, Material mat) {
        this.spritesheetName = spritesheetName;
        this.material = mat;
        this.setLocation(location);
        this.updateAnimationController();
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getSpritesheetName() {
        return this.spritesheetName;
    }

    public PropState getState() {
        if (this.getAttributes().getHealth().getCurrentValue() <= 0) {
            return PropState.DESTROYED;
        }
        if ((double)this.getAttributes().getHealth().getCurrentValue().shortValue() <= (double)this.getAttributes().getHealth().getMaxValue().shortValue() * 0.5) {
            return PropState.DAMAGED;
        }
        return PropState.INTACT;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setSpritesheetName(String spriteName) {
        this.spritesheetName = spriteName;
        this.updateAnimationController();
    }

    public boolean isObstacle() {
        return this.isObstacle;
    }

    public void setObstacle(boolean isObstacle) {
        this.isObstacle = isObstacle;
    }

    public boolean isAddShadow() {
        return this.addShadow;
    }

    public void setAddShadow(boolean addShadow) {
        this.addShadow = addShadow;
    }

    public Rotation getSpriteRotation() {
        return this.rotation;
    }

    public void setSpriteRotation(Rotation spriteRotation) {
        this.rotation = spriteRotation;
    }

    public boolean flipHorizontally() {
        return this.flipHorizontally;
    }

    public void setFlipHorizontally(boolean flipHorizontally) {
        this.flipHorizontally = flipHorizontally;
    }

    public boolean flipVertically() {
        return this.flipVertically;
    }

    public void setFlipVertically(boolean flipVertically) {
        this.flipVertically = flipVertically;
    }

    private void updateAnimationController() {
        PropAnimationController controller = new PropAnimationController(this);
        Game.getEntityControllerManager().addController(this, controller);
        if (Game.getEnvironment() != null && Game.getEnvironment().isLoaded()) {
            Game.getLoop().attach(controller);
        }
    }
}

