/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.EntityInfo;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.MessageArgs;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.animation.IAnimationController;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@EntityInfo
public abstract class Entity
implements IEntity {
    private final List<MessageAction> messageActions = new CopyOnWriteArrayList<MessageAction>();
    private final List<String> tags = new CopyOnWriteArrayList<String>();
    private float angle;
    private Rectangle2D boundingBox;
    private float height;
    private int mapId;
    private Point2D mapLocation = new Point2D.Double(0.0, 0.0);
    private String name;
    private RenderType renderType;
    private float width;

    protected Entity() {
        EntityInfo info = this.getClass().getAnnotation(EntityInfo.class);
        this.width = info.width();
        this.height = info.height();
        this.renderType = info.renderType();
    }

    protected Entity(int mapId) {
        this();
        this.mapId = mapId;
    }

    protected Entity(String name) {
        this();
        this.name = name;
    }

    protected Entity(int mapId, String name) {
        this(mapId);
        this.name = name;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public IAnimationController getAnimationController() {
        return Game.getEntityControllerManager().getAnimationController(this);
    }

    @Override
    public Rectangle2D getBoundingBox() {
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        this.boundingBox = new Rectangle2D.Double(this.getLocation().getX(), this.getLocation().getY(), this.getWidth(), this.getHeight());
        return this.boundingBox;
    }

    @Override
    public Point2D getDimensionCenter() {
        return new Point2D.Double(this.getLocation().getX() + (double)this.getWidth() * 0.5, this.getLocation().getY() + (double)this.getHeight() * 0.5);
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public Point2D getLocation() {
        return this.mapLocation;
    }

    @Override
    public int getMapId() {
        return this.mapId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public double getX() {
        return this.getLocation().getX();
    }

    @Override
    public double getY() {
        return this.getLocation().getY();
    }

    @Override
    public String sendMessage(Object sender, String message) {
        for (MessageAction action : this.messageActions.stream().filter(x -> x.getMessage().equals(message)).collect(Collectors.toList())) {
            action.execute(sender);
        }
        return null;
    }

    @Override
    public void setHeight(float height) {
        this.height = height;
        this.boundingBox = null;
    }

    @Override
    public void setLocation(double x, double y) {
        this.setLocation(new Point2D.Double(x, y));
    }

    @Override
    public void setLocation(Point2D location) {
        this.mapLocation = location;
        this.boundingBox = null;
    }

    @Override
    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    @Override
    public void setSize(float width, float height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    @Override
    public void setWidth(float width) {
        this.width = width;
        this.boundingBox = null;
    }

    @Override
    public void setX(double x) {
        this.getLocation().setLocation(x, this.getY());
    }

    @Override
    public void setY(double y) {
        this.getLocation().setLocation(this.getX(), y);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    @Override
    public void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    @Override
    public void removeTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.remove(tag);
        }
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null && !this.getName().isEmpty()) {
            sb.append(this.getName());
        } else {
            sb.append(this.getClass().getSimpleName());
        }
        sb.append(" #");
        sb.append(this.getMapId());
        return sb.toString();
    }

    @Override
    public void registerMessageAction(String message, Consumer<MessageArgs> action) {
        this.messageActions.add(new MessageAction(message, action));
    }

    private class MessageAction {
        private final String message;
        private final Consumer<MessageArgs> action;

        public MessageAction(String message, Consumer<MessageArgs> action) {
            this.message = message;
            this.action = action;
        }

        public void execute(Object sender) {
            this.action.accept(new MessageArgs(Entity.this, sender, this.getMessage()));
        }

        public String getMessage() {
            return this.message;
        }
    }
}

